/*
 * Decompiled with CFR 0.152.
 */
package com.sc.sicanet.stp_ws.services;

import com.sc.sicanet.stp_ws.dto.ConciliacionRequestDTO;
import com.sc.sicanet.stp_ws.models.Conciliacion;
import com.sc.sicanet.stp_ws.services.ConciliacionService;
import com.sc.sicanet.stp_ws.services.STPService;
import com.sc.sicanet.stp_ws.utils.CryptoHanler;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Service;

@Service
public class ConciliacionServiceImpl
implements ConciliacionService {
    @Value(value="${config.crypto.alias}")
    private String alias;
    @Value(value="${config.crypto.password}")
    private String password;
    final STPService stpService;

    public ConciliacionServiceImpl(STPService stpService) {
        this.stpService = stpService;
    }

    @Override
    public Optional<Conciliacion> postConciliacion(ConciliacionRequestDTO conciliacionRequestDTO) {
        CryptoHanler cryptoHanler = new CryptoHanler();
        try {
            String cadenaOriginal = "||" + this.alias + "|" + conciliacionRequestDTO.getTipoOrden() + "|||";
            System.out.println("cadenaOriginal -> " + cadenaOriginal);
            String firma = cryptoHanler.sign(cadenaOriginal, this.password, this.alias);
            conciliacionRequestDTO.setFirma(firma);
            return this.stpService.postConciliacion(conciliacionRequestDTO);
        }
        catch (Exception e) {
            System.out.println("e -> " + e.getMessage());
            Conciliacion conciliacion = new Conciliacion(HttpStatusCode.valueOf((int)400), e.getMessage());
            return Optional.of(conciliacion);
        }
    }
}

