/*
 * Decompiled with CFR 0.152.
 */
package com.sc.sicanet.migracion_sicanet.service;

import com.sc.sicanet.migracion_sicanet.DTO.SocioeconomicosDTO;
import com.sc.sicanet.migracion_sicanet.entity.CatDestinos;
import com.sc.sicanet.migracion_sicanet.entity.CatOrigenRecurso;
import com.sc.sicanet.migracion_sicanet.entity.Persona;
import com.sc.sicanet.migracion_sicanet.entity.PldCatPersonasRecursoDestino;
import com.sc.sicanet.migracion_sicanet.entity.PldCatPersonasRecursoOrigen;
import com.sc.sicanet.migracion_sicanet.repository.CatDestinoRecursoRepository;
import com.sc.sicanet.migracion_sicanet.repository.CatOrigenRecursoRepository;
import com.sc.sicanet.migracion_sicanet.repository.PersonaRepository;
import com.sc.sicanet.migracion_sicanet.repository.PldCatPersonasRecursoDestinoRepository;
import com.sc.sicanet.migracion_sicanet.repository.PldCatPersonasRecursoOrigenRepository;
import com.sc.sicanet.migracion_sicanet.service.SocioeconomicosService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.time.LocalDateTime;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SocioeconomicosServiceImpl
implements SocioeconomicosService {
    @Autowired
    private PersonaRepository personaRepository;
    @Autowired
    private PldCatPersonasRecursoDestinoRepository pldCatPersonasRecursoDestinoRepository;
    @Autowired
    private PldCatPersonasRecursoOrigenRepository pldCatPersonasRecursoOrigenRepository;
    @Autowired
    private CatDestinoRecursoRepository catDestinoRecursoRepository;
    @Autowired
    private CatOrigenRecursoRepository catOrigenRecursoRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public PldCatPersonasRecursoDestino guardarDestinoRecurso(PldCatPersonasRecursoDestino pldCatPersonasRecursoDestino) {
        return (PldCatPersonasRecursoDestino)this.pldCatPersonasRecursoDestinoRepository.save(pldCatPersonasRecursoDestino);
    }

    @Override
    public PldCatPersonasRecursoOrigen guardarOrigenRecurso(PldCatPersonasRecursoOrigen pldCatPersonasRecursoOrigen) {
        return (PldCatPersonasRecursoOrigen)this.pldCatPersonasRecursoOrigenRepository.save(pldCatPersonasRecursoOrigen);
    }

    @Override
    public Optional<PldCatPersonasRecursoDestino> consultarRecursoDestino(Persona persona) {
        return this.pldCatPersonasRecursoDestinoRepository.findByPersonaAndEstatus(persona, "A");
    }

    @Override
    public Optional<PldCatPersonasRecursoOrigen> consultarRecursoOrigen(Persona persona) {
        return this.pldCatPersonasRecursoOrigenRepository.findByPersonaAndEstatus(persona, "A");
    }

    @Override
    public PldCatPersonasRecursoDestino convertirDatosDeRecursosDestino(SocioeconomicosDTO pldCatPersonasRecursoDestinoDTO, Persona persona) {
        Optional<PldCatPersonasRecursoDestino> recursoDestinoExistente;
        LocalDateTime fechaActual = LocalDateTime.now();
        Optional<CatDestinos> catDestinos = this.catDestinoRecursoRepository.findByDestino(pldCatPersonasRecursoDestinoDTO.getDestino_recurso());
        PldCatPersonasRecursoDestino pldCatPersonasRecursoDestino = new PldCatPersonasRecursoDestino(fechaActual, catDestinos.isPresent() ? catDestinos.get().getPkCatDestino() : 0, "", 0, "API Migracion", "A", 1, "");
        pldCatPersonasRecursoDestino.setFechaControl(fechaActual);
        pldCatPersonasRecursoDestino.setFechaRegistro(fechaActual);
        if (persona.getPkPersona() != 0 && (recursoDestinoExistente = this.consultarRecursoDestino(persona)).isPresent()) {
            pldCatPersonasRecursoDestino.setPkPldCatPersonasRecursoDestino(recursoDestinoExistente.get().getPkPldCatPersonasRecursoDestino());
            pldCatPersonasRecursoDestino.setFechaControl(recursoDestinoExistente.get().getFechaControl());
            pldCatPersonasRecursoDestino.setFechaRegistro(recursoDestinoExistente.get().getFechaRegistro());
        }
        return pldCatPersonasRecursoDestino;
    }

    @Override
    public PldCatPersonasRecursoOrigen convertirDatosDeRecursosOrigen(SocioeconomicosDTO pldCatPersonasRecursoOrigenDTO, Persona persona) {
        Optional<PldCatPersonasRecursoOrigen> recursoOrigenExistente;
        LocalDateTime fechaActual = LocalDateTime.now();
        Optional<CatOrigenRecurso> catOrigenRecurso = this.catOrigenRecursoRepository.findByDescripcion(pldCatPersonasRecursoOrigenDTO.getOrigen_recurso());
        PldCatPersonasRecursoOrigen pldCatPersonasRecursoOrigen = new PldCatPersonasRecursoOrigen(fechaActual, catOrigenRecurso.isPresent() ? catOrigenRecurso.get().getPkCatOrigenRecurso() : 0, "", 0, "API Migracion", "A", 1, "");
        pldCatPersonasRecursoOrigen.setFechaControl(fechaActual);
        pldCatPersonasRecursoOrigen.setFechaRegistro(fechaActual);
        if (persona.getPkPersona() != 0 && (recursoOrigenExistente = this.consultarRecursoOrigen(persona)).isPresent()) {
            pldCatPersonasRecursoOrigen.setPkPldCatPersonasRecursoOrigen(recursoOrigenExistente.get().getPkPldCatPersonasRecursoOrigen());
            pldCatPersonasRecursoOrigen.setFechaControl(recursoOrigenExistente.get().getFechaControl());
            pldCatPersonasRecursoOrigen.setFechaRegistro(recursoOrigenExistente.get().getFechaRegistro());
        }
        return pldCatPersonasRecursoOrigen;
    }
}

