/*
 * Decompiled with CFR 0.152.
 */
package com.sc.sicanet.migracion_sicanet.service;

import com.sc.sicanet.migracion_sicanet.DTO.PrestamosSolicitudesDTO;
import com.sc.sicanet.migracion_sicanet.entity.PrestamosSolicitudes;
import com.sc.sicanet.migracion_sicanet.entity.Socio;
import com.sc.sicanet.migracion_sicanet.repository.SocioRepository;
import com.sc.sicanet.migracion_sicanet.service.MigracionPrestamosSolicitudesService;
import com.sc.sicanet.migracion_sicanet.service.PersonaService;
import com.sc.sicanet.migracion_sicanet.service.PrestamosSolicitudesService;
import com.sc.sicanet.migracion_sicanet.service.SocioService;
import jakarta.transaction.Transactional;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class MigracionPrestamosSolicitudesServiceImpl
implements MigracionPrestamosSolicitudesService {
    private final SocioRepository socioRepository;
    private final PersonaService personaService;
    private final SocioService socioService;
    private final PrestamosSolicitudesService prestamosSolicitudesService;

    public MigracionPrestamosSolicitudesServiceImpl(SocioRepository socioRepository, PersonaService personaService, SocioService socioService, PrestamosSolicitudesService prestamosSolicitudesService) {
        this.socioRepository = socioRepository;
        this.personaService = personaService;
        this.socioService = socioService;
        this.prestamosSolicitudesService = prestamosSolicitudesService;
    }

    @Override
    @Transactional
    public Map<String, String> migrarSolicitud(PrestamosSolicitudesDTO prestamosSolicitudesDTO) {
        Optional<Socio> socio = this.socioRepository.findByRefenciaSocio(prestamosSolicitudesDTO.getReferencia_acreditado());
        HashMap<String, String> resultado = new HashMap<String, String>();
        if (!socio.isPresent()) {
            resultado.put("msg", "Acreditado No Encontrado");
            resultado.put("code", String.valueOf(HttpStatus.BAD_REQUEST));
            return resultado;
        }
        PrestamosSolicitudes prestamosSolicitudes = this.prestamosSolicitudesService.convertirDatosDePrestamosSolicitudes(prestamosSolicitudesDTO, socio.get());
        return this.guardarActualizarSolicitud(prestamosSolicitudes, socio.get());
    }

    @Override
    public void guardarSolicitud(PrestamosSolicitudes prestamosSolicitudes, Socio socio, Boolean actualizar) {
        prestamosSolicitudes.setSocio(socio);
        this.prestamosSolicitudesService.guardarPrestamosSolicitudes(prestamosSolicitudes);
    }

    @Override
    public Map<String, String> guardarActualizarSolicitud(PrestamosSolicitudes prestamosSolicitudes, Socio socio) {
        boolean actualizar = prestamosSolicitudes.getControl() != null && !prestamosSolicitudes.getControl().isEmpty();
        HashMap<String, String> respuesta = new HashMap<String, String>();
        if (actualizar) {
            Optional<PrestamosSolicitudes> solicitudExistente = this.prestamosSolicitudesService.consultaSolicitudesByControlAndEstatus(prestamosSolicitudes.getControl(), "P");
            if (solicitudExistente.isPresent()) {
                PrestamosSolicitudes solicitud = solicitudExistente.get();
                if (!"P".equals(solicitud.getEstatus())) {
                    respuesta.put("mensaje", "No Se Puede Actualizar La Solicitud Ya Que No Se Encuentra En Estatus 'P'");
                    respuesta.put("code", "400");
                    return respuesta;
                }
            } else {
                actualizar = false;
            }
        } else {
            actualizar = false;
        }
        String mensaje = actualizar ? "Actualizaci\u00f3n" : "Guardado";
        String codigo = actualizar ? "201" : "200";
        this.guardarSolicitud(prestamosSolicitudes, socio, actualizar);
        respuesta.put("mensaje", mensaje);
        respuesta.put("code", codigo);
        respuesta.put("referencia_acreditado", socio.getReferenciaSocio());
        respuesta.put("control_solicitud", prestamosSolicitudes.getControl());
        return respuesta;
    }
}

