/*
 * Decompiled with CFR 0.152.
 */
package com.sc.sicanet.migracion_sicanet.service;

import com.sc.sicanet.migracion_sicanet.DTO.DomicilioDTO;
import com.sc.sicanet.migracion_sicanet.entity.CatGeoEntidades;
import com.sc.sicanet.migracion_sicanet.entity.CatGeoLocalidades;
import com.sc.sicanet.migracion_sicanet.entity.CatGeoMunicipios;
import com.sc.sicanet.migracion_sicanet.entity.CatTipoAsentamiento;
import com.sc.sicanet.migracion_sicanet.entity.CatTipoCasa;
import com.sc.sicanet.migracion_sicanet.entity.CatTipoVialidad;
import com.sc.sicanet.migracion_sicanet.entity.CatTipoViveZona;
import com.sc.sicanet.migracion_sicanet.entity.CatTipoVivienda;
import com.sc.sicanet.migracion_sicanet.entity.CodigosPostales;
import com.sc.sicanet.migracion_sicanet.entity.Domicilio;
import com.sc.sicanet.migracion_sicanet.entity.Persona;
import com.sc.sicanet.migracion_sicanet.entity.PldPaises;
import com.sc.sicanet.migracion_sicanet.repository.CatGeoEntidadesRepository;
import com.sc.sicanet.migracion_sicanet.repository.CatGeoLocalidadesRepository;
import com.sc.sicanet.migracion_sicanet.repository.CatGeoMunicipiosRepository;
import com.sc.sicanet.migracion_sicanet.repository.CatTipoAsentamientoRepository;
import com.sc.sicanet.migracion_sicanet.repository.CatTipoCasaRepository;
import com.sc.sicanet.migracion_sicanet.repository.CatTipoVialidadRepository;
import com.sc.sicanet.migracion_sicanet.repository.CatTipoViveZonaRepository;
import com.sc.sicanet.migracion_sicanet.repository.CatTipoViviendaRepository;
import com.sc.sicanet.migracion_sicanet.repository.CodigosPostalesRepository;
import com.sc.sicanet.migracion_sicanet.repository.DomicilioRepository;
import com.sc.sicanet.migracion_sicanet.repository.PersonaRepository;
import com.sc.sicanet.migracion_sicanet.repository.PldPaisesRepository;
import com.sc.sicanet.migracion_sicanet.service.DomicilioService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DomicilioServiceImpl
implements DomicilioService {
    @Autowired
    private DomicilioRepository domicilioRepository;
    @Autowired
    private PersonaRepository personaRepository;
    @Autowired
    private PldPaisesRepository pldPaisesRepository;
    @Autowired
    private CatGeoEntidadesRepository catGeoEntidadesRepository;
    @Autowired
    private CatGeoLocalidadesRepository catGeoLocalidadesRepository;
    @Autowired
    private CatGeoMunicipiosRepository catGeoMunicipiosRepository;
    @Autowired
    private CatTipoViviendaRepository catTipoViviendaRepository;
    @Autowired
    private CatTipoCasaRepository catTipoCasaRepository;
    @Autowired
    private CatTipoViveZonaRepository catTipoViveZonaRepository;
    @Autowired
    private CatTipoAsentamientoRepository catTipoAsentamientoRepository;
    @Autowired
    private CatTipoVialidadRepository catTipoVialidadRepository;
    @Autowired
    private CodigosPostalesRepository codigosPostalesRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Optional<Domicilio> consultaDomicilio(Persona persona, String tipoDomicilio, String estatus, String dispositivo) {
        return this.domicilioRepository.findByPersonaAndTipoDomicilioAndEstatusAndDispositivo(persona, tipoDomicilio, estatus, dispositivo);
    }

    @Override
    public Domicilio guardarDomicilio(Domicilio domicilio) {
        return (Domicilio)this.domicilioRepository.save(domicilio);
    }

    @Override
    public Domicilio convertirDatosDeDomicilio(DomicilioDTO domicilioDTO, Persona persona, boolean es_personal) {
        Optional<Domicilio> domicilioExistente;
        LocalDateTime fechaActual = LocalDateTime.now();
        Optional<PldPaises> pldPaises = this.pldPaisesRepository.findByNombre(domicilioDTO.getPais());
        Optional<CatGeoEntidades> catGeoEntidades = this.catGeoEntidadesRepository.findByEntidad(domicilioDTO.getEntidad());
        Optional<CatGeoMunicipios> catGeoMunicipios = this.catGeoMunicipiosRepository.findByMunicipioAndFkCatEntidad(domicilioDTO.getMunicipio(), catGeoEntidades.get().getPkCatEntidad());
        Optional<CatGeoLocalidades> catGeoLocalidades = this.catGeoLocalidadesRepository.findByLocalidadAndFkCatMunicipioAndFkCatEntidad(domicilioDTO.getLocalidad(), catGeoMunicipios.get().getPkCatMunicipio(), catGeoEntidades.get().getPkCatEntidad());
        Optional<CatTipoVivienda> catTipoVivienda = this.catTipoViviendaRepository.findByDescripcion(domicilioDTO.getTipo_vivienda());
        Optional<CatTipoCasa> catTipoCasa = this.catTipoCasaRepository.findByTipoCasa(domicilioDTO.getTipo_casa());
        Optional<CatTipoViveZona> catTipoViveZona = this.catTipoViveZonaRepository.findByDescripcion(domicilioDTO.getZona_residencia());
        Optional<CatTipoAsentamiento> catTipoAsentamiento = this.catTipoAsentamientoRepository.findByDescripcion(domicilioDTO.getTipo_asentamiento());
        Optional<CatTipoVialidad> catTipoVialidad = this.catTipoVialidadRepository.findByTipoVialidad(domicilioDTO.getTipo_vialidad());
        Optional<CodigosPostales> codigosPostales = this.codigosPostalesRepository.findByCodigoPostalAndFkCatEntidadAndFkCatMunicipio(domicilioDTO.getCp(), catGeoEntidades.get().getPkCatEntidad(), catGeoMunicipios.get().getPkCatMunicipio());
        String tipo_domicilio = es_personal ? "DP" : "DL";
        Domicilio domicilio = new Domicilio(fechaActual, catTipoVialidad.isPresent() ? catTipoVialidad.get().getTipoVialidad() : "", domicilioDTO.getNombre_vialidad(), domicilioDTO.getNum_exterior(), domicilioDTO.getNum_interior(), "", "", "", catTipoCasa.isPresent() ? catTipoCasa.get().getTipoCasa() : "", domicilioDTO.getAntiguedad_domicilio(), codigosPostales.isPresent() ? codigosPostales.get().getCodigoPostal() : "", catTipoAsentamiento.isPresent() ? catTipoAsentamiento.get().getDescripcion() : "", domicilioDTO.getNombre_asentamiento(), tipo_domicilio, 0.0, 0.0, 0.0, "", catTipoViveZona.isPresent() ? catTipoViveZona.get().getAcronimo() : "", catTipoVivienda.isPresent() ? catTipoVivienda.get().getAcronimo() : "", "", 0, "API Migracion", "A", 1, catGeoEntidades.isPresent() ? catGeoEntidades.get().getPkCatEntidad() : 0, catGeoMunicipios.isPresent() ? catGeoMunicipios.get().getPkCatMunicipio() : 0, catGeoLocalidades.isPresent() ? catGeoLocalidades.get().getPkCatLocalidad() : 0, pldPaises.isPresent() ? pldPaises.get().getPkPais() : 0, "", domicilioDTO.getUuid());
        if (domicilioDTO.getUuid() == null || domicilioDTO.getUuid().isEmpty()) {
            domicilio.setUuid(UUID.randomUUID().toString());
        } else {
            domicilio.setUuid(domicilioDTO.getUuid());
        }
        domicilio.setFechaControl(fechaActual);
        domicilio.setFechaRegistro(fechaActual);
        if (persona.getPkPersona() != 0 && !(domicilioExistente = this.consultaDomicilio(persona, tipo_domicilio, "A", "Api Migracion")).isEmpty()) {
            domicilio.setPkDomicilio(domicilioExistente.get().getPkDomicilio());
            domicilio.setFechaControl(domicilioExistente.get().getFechaControl());
            domicilio.setFechaRegistro(domicilioExistente.get().getFechaRegistro());
        }
        return domicilio;
    }
}

