/*
 * Decompiled with CFR 0.152.
 */
package com.sc.sicanet.migracion_sicanet.service;

import com.sc.sicanet.migracion_sicanet.DTO.PerfilTransaccionalDTO;
import com.sc.sicanet.migracion_sicanet.entity.CatFormaPago;
import com.sc.sicanet.migracion_sicanet.entity.CatPeriodos;
import com.sc.sicanet.migracion_sicanet.entity.PerfilTransaccional;
import com.sc.sicanet.migracion_sicanet.entity.PerfilTransaccionalMontos;
import com.sc.sicanet.migracion_sicanet.entity.Persona;
import com.sc.sicanet.migracion_sicanet.repository.CatFormaPagoRepository;
import com.sc.sicanet.migracion_sicanet.repository.CatPeriodosRepository;
import com.sc.sicanet.migracion_sicanet.repository.PerfilTransaccionalMontosRepository;
import com.sc.sicanet.migracion_sicanet.repository.PerfilTransaccionalRepository;
import com.sc.sicanet.migracion_sicanet.repository.PersonaRepository;
import com.sc.sicanet.migracion_sicanet.service.PerfilTransaccionalService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PerfilTransaccionalServiceImpl
implements PerfilTransaccionalService {
    @Autowired
    private PerfilTransaccionalRepository perfilTransaccionalRepository;
    @Autowired
    private PerfilTransaccionalMontosRepository perfilTransaccionalMontosRepository;
    @Autowired
    private PersonaRepository personaRepository;
    @Autowired
    private CatPeriodosRepository catPeriodosRepository;
    @Autowired
    private CatFormaPagoRepository catFormaPagoRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public PerfilTransaccional guardarPerfilTransaccional(PerfilTransaccional perfilTransaccional) {
        return (PerfilTransaccional)this.perfilTransaccionalRepository.save(perfilTransaccional);
    }

    @Override
    public Optional<PerfilTransaccional> consultaPerfilTransaccional(Persona persona) {
        return this.perfilTransaccionalRepository.findByPersonaAndEstatus(persona, "A");
    }

    @Override
    public PerfilTransaccional convertirDatosDePerfilTransaccional(PerfilTransaccionalDTO perfilTransaccionalDTO, Persona persona) {
        Optional<PerfilTransaccional> perfilTransaccionalExistente;
        LocalDateTime fechaHoraActual = LocalDateTime.now();
        Optional<PerfilTransaccionalMontos> perfilTransaccionalMontos = this.perfilTransaccionalMontosRepository.findByDescripcion(perfilTransaccionalDTO.getDisponibilidad_mensual());
        Optional<CatPeriodos> catPeriodos = this.catPeriodosRepository.findByPeriodo(perfilTransaccionalDTO.getPeriodicidad());
        String formasPagoConcatenadas = perfilTransaccionalDTO.getForma_pago().stream().distinct().map(this.catFormaPagoRepository::findByForma).filter(Optional::isPresent).map(Optional::get).map(CatFormaPago::getPkCatForma).collect(Collectors.joining(", "));
        PerfilTransaccional perfilTransaccional = new PerfilTransaccional(fechaHoraActual, perfilTransaccionalMontos.isPresent() ? perfilTransaccionalMontos.get().getPkPerfilTransaccionalMontos() : 0, perfilTransaccionalDTO.getNumero_operacion_por_mes(), catPeriodos.isPresent() ? catPeriodos.get().getAcronimo() : "", formasPagoConcatenadas, "", 0, "API Migracion", "A", 1, "");
        perfilTransaccional.setFechaControl(fechaHoraActual);
        perfilTransaccional.setFechaRegistro(fechaHoraActual);
        if (persona.getPkPersona() != 0 && !(perfilTransaccionalExistente = this.consultaPerfilTransaccional(persona)).isEmpty()) {
            perfilTransaccional.setPkPerfilTransaccional(perfilTransaccionalExistente.get().getPkPerfilTransaccional());
            perfilTransaccional.setFechaControl(perfilTransaccionalExistente.get().getFechaControl());
            perfilTransaccional.setFechaRegistro(perfilTransaccionalExistente.get().getFechaRegistro());
        }
        return perfilTransaccional;
    }
}

