/*
 * Decompiled with CFR 0.152.
 */
package com.sc.sicanet.migracion_sicanet.service;

import com.sc.sicanet.migracion_sicanet.DTO.PersonaDTO;
import com.sc.sicanet.migracion_sicanet.entity.CatContacto;
import com.sc.sicanet.migracion_sicanet.entity.Domicilio;
import com.sc.sicanet.migracion_sicanet.entity.InformacionPEPS;
import com.sc.sicanet.migracion_sicanet.entity.Laboral;
import com.sc.sicanet.migracion_sicanet.entity.PerfilTransaccional;
import com.sc.sicanet.migracion_sicanet.entity.Persona;
import com.sc.sicanet.migracion_sicanet.entity.PldCatPersonasRecursoDestino;
import com.sc.sicanet.migracion_sicanet.entity.PldCatPersonasRecursoOrigen;
import com.sc.sicanet.migracion_sicanet.entity.RepresentanteLegal;
import com.sc.sicanet.migracion_sicanet.entity.Socio;
import com.sc.sicanet.migracion_sicanet.repository.PersonaRepository;
import com.sc.sicanet.migracion_sicanet.service.ContactoService;
import com.sc.sicanet.migracion_sicanet.service.DomicilioService;
import com.sc.sicanet.migracion_sicanet.service.InformacionPepsService;
import com.sc.sicanet.migracion_sicanet.service.LaboralService;
import com.sc.sicanet.migracion_sicanet.service.MigracionService;
import com.sc.sicanet.migracion_sicanet.service.PerfilTransaccionalService;
import com.sc.sicanet.migracion_sicanet.service.PersonaService;
import com.sc.sicanet.migracion_sicanet.service.RepresentanteLegalService;
import com.sc.sicanet.migracion_sicanet.service.SocioService;
import com.sc.sicanet.migracion_sicanet.service.SocioeconomicosService;
import jakarta.transaction.Transactional;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MigracionServiceImpl
implements MigracionService {
    private final PersonaRepository personaRepository;
    @Autowired
    private PersonaService personaService;
    @Autowired
    private LaboralService laboralService;
    @Autowired
    private SocioService socioService;
    @Autowired
    private DomicilioService domicilioService;
    @Autowired
    private PerfilTransaccionalService perfilTransaccionalService;
    @Autowired
    private InformacionPepsService informacionPepsService;
    @Autowired
    RepresentanteLegalService representanteLegalService;
    @Autowired
    private ContactoService contactoService;
    @Autowired
    private SocioeconomicosService socioeconomicosService;

    public MigracionServiceImpl(PersonaRepository personaRepository) {
        this.personaRepository = personaRepository;
    }

    @Override
    public List<Persona> findAll() {
        return (List)this.personaRepository.findAll();
    }

    @Override
    public Optional<Persona> findById(int id) {
        return this.personaRepository.findById(id);
    }

    @Override
    @Transactional
    public Map<String, String> guardarActualizarPersona(Persona persona, Laboral laboral, Domicilio domicilio, Domicilio domicilioLaboral, PerfilTransaccional perfilTransaccional, InformacionPEPS informacionPEPS, RepresentanteLegal representanteLegal, Persona personaRepresentante, Domicilio domicilioRepresentante, CatContacto catContacto, PldCatPersonasRecursoOrigen pldCatPersonasRecursoOrigen, PldCatPersonasRecursoDestino pldCatPersonasRecursoDestino) {
        boolean actualizacion = true;
        String mensaje = "Actualizado";
        String code = "201";
        Map<Object, Object> personaGuardadaActualizada = new HashMap();
        if (persona.getPkPersona() == 0) {
            actualizacion = false;
            mensaje = "Guardado";
            code = "200";
        }
        this.guardarPersona(persona, laboral, domicilio, domicilioLaboral, perfilTransaccional, informacionPEPS, representanteLegal, personaRepresentante, domicilioRepresentante, catContacto, pldCatPersonasRecursoOrigen, pldCatPersonasRecursoDestino, actualizacion);
        personaGuardadaActualizada = this.socioService.recuperarSocio(persona);
        personaGuardadaActualizada.put("referenciaAcreditado", (String)personaGuardadaActualizada.get("referenciaSocio"));
        personaGuardadaActualizada.put("nombreAcreditado", (String)personaGuardadaActualizada.get("nombreSocio"));
        personaGuardadaActualizada.put("uuidDomicilioPersonal", domicilio.getUuid());
        personaGuardadaActualizada.put("uuidDomicilioLaboral", domicilioLaboral.getUuid());
        personaGuardadaActualizada.put("mensaje", mensaje);
        personaGuardadaActualizada.put("code", code);
        return personaGuardadaActualizada;
    }

    @Override
    public Map<String, String> migracion(PersonaDTO personaDTO) {
        Persona persona = this.personaService.convertirADatosDePersona(personaDTO);
        Domicilio domicilio = this.domicilioService.convertirDatosDeDomicilio(personaDTO.getDomicilio_personal(), persona, true);
        Domicilio domicilio_laboral = this.domicilioService.convertirDatosDeDomicilio(personaDTO.getLaboral().getDomicilio_laboral(), persona, false);
        Laboral laboral = this.laboralService.convertirADatosDeLaboral(personaDTO.getLaboral(), persona, domicilio_laboral);
        PerfilTransaccional perfilTransaccional = this.perfilTransaccionalService.convertirDatosDePerfilTransaccional(personaDTO.getPerfil_transaccional(), persona);
        InformacionPEPS informacionPEPS = this.informacionPepsService.convertirDatosDeInformacionPeps(personaDTO.getInformacion_peps(), persona);
        CatContacto catContacto = this.contactoService.convertirDatosDeContacto(personaDTO.getContacto(), persona);
        PldCatPersonasRecursoDestino pldCatPersonasRecursoDestino = this.socioeconomicosService.convertirDatosDeRecursosDestino(personaDTO.getSocioeconomicos(), persona);
        PldCatPersonasRecursoOrigen pldCatPersonasRecursoOrigen = this.socioeconomicosService.convertirDatosDeRecursosOrigen(personaDTO.getSocioeconomicos(), persona);
        RepresentanteLegal representanteLegal = new RepresentanteLegal();
        Persona personaRepresentante = new Persona();
        Domicilio domicilioRepresentante = new Domicilio();
        if (personaDTO.getTipo_persona().equals("M")) {
            representanteLegal = this.representanteLegalService.convertirDatos(personaDTO.getRepresentante_legal(), persona);
            personaRepresentante = representanteLegal.getRepresentante();
            domicilioRepresentante = this.domicilioService.convertirDatosDeDomicilio(personaDTO.getRepresentante_legal().getDomicilio_personal(), personaRepresentante, true);
        }
        return this.guardarActualizarPersona(persona, laboral, domicilio, domicilio_laboral, perfilTransaccional, informacionPEPS, representanteLegal, personaRepresentante, domicilioRepresentante, catContacto, pldCatPersonasRecursoOrigen, pldCatPersonasRecursoDestino);
    }

    @Override
    public void guardarDomicilio(Domicilio domicilio, Persona persona) {
        domicilio.setPersona(persona);
        this.domicilioService.guardarDomicilio(domicilio);
    }

    @Override
    public void guardarLaboral(Laboral laboral, Domicilio domicilioLaboral, Persona persona) {
        laboral.setDomicilio(domicilioLaboral);
        laboral.setPersona(persona);
        this.laboralService.guardarLaboral(laboral);
    }

    @Override
    public void guardarInformacionPEPS(InformacionPEPS informacionPEPS, Persona persona) {
        informacionPEPS.setPersona(persona);
        this.informacionPepsService.guardarInformacionPeps(informacionPEPS);
    }

    @Override
    public void guardarPerfilTransaccional(PerfilTransaccional perfilTransaccional, Persona persona) {
        perfilTransaccional.setPersona(persona);
        this.perfilTransaccionalService.guardarPerfilTransaccional(perfilTransaccional);
    }

    @Override
    public void guardarCatContacto(CatContacto catContacto, Persona persona) {
        catContacto.setPersona(persona);
        this.contactoService.guardarContacto(catContacto);
    }

    @Override
    public void guardarSocieconomicos(PldCatPersonasRecursoOrigen pldCatPersonasRecursoOrigen, PldCatPersonasRecursoDestino pldCatPersonasRecursoDestino, Persona persona) {
        pldCatPersonasRecursoOrigen.setPersona(persona);
        pldCatPersonasRecursoDestino.setPersona(persona);
        this.socioeconomicosService.guardarOrigenRecurso(pldCatPersonasRecursoOrigen);
        this.socioeconomicosService.guardarDestinoRecurso(pldCatPersonasRecursoDestino);
    }

    @Override
    @Transactional
    public void guardarPersona(Persona persona, Laboral laboral, Domicilio domicilio, Domicilio domicilioLaboral, PerfilTransaccional perfilTransaccional, InformacionPEPS informacionPEPS, RepresentanteLegal representanteLegal, Persona personaRepresentante, Domicilio domicilioRepresentante, CatContacto catContacto, PldCatPersonasRecursoOrigen pldCatPersonasRecursoOrigen, PldCatPersonasRecursoDestino pldCatPersonasRecursoDestino, boolean actualizar) {
        if (!actualizar) {
            Socio socio = new Socio();
            socio.setFkPersona(persona);
            this.socioService.guardarSocio(socio);
        } else {
            this.personaService.guardarPersonas(persona);
        }
        if (persona.getTipoPersona().equals("M")) {
            Optional<Persona> representanteExistente = this.personaService.consultaPersonas(personaRepresentante);
            if (representanteExistente.isPresent()) {
                personaRepresentante = representanteExistente.get();
                this.representanteLegalService.guardarRepresentante(representanteLegal);
                domicilioRepresentante.setPersona(personaRepresentante);
                this.domicilioService.guardarDomicilio(domicilioRepresentante);
            } else {
                personaRepresentante = this.personaService.guardarPersonas(personaRepresentante);
                this.representanteLegalService.guardarRepresentante(representanteLegal);
                domicilioRepresentante.setPersona(personaRepresentante);
                this.domicilioService.guardarDomicilio(domicilioRepresentante);
            }
            representanteLegal.setPersona(persona);
            representanteLegal.setRepresentante(personaRepresentante);
        }
        this.guardarDomicilio(domicilio, persona);
        this.guardarDomicilio(domicilioLaboral, persona);
        this.guardarLaboral(laboral, domicilioLaboral, persona);
        this.guardarPerfilTransaccional(perfilTransaccional, persona);
        this.guardarInformacionPEPS(informacionPEPS, persona);
        this.guardarCatContacto(catContacto, persona);
        this.guardarSocieconomicos(pldCatPersonasRecursoOrigen, pldCatPersonasRecursoDestino, persona);
    }
}

