/*
 * Decompiled with CFR 0.152.
 */
package com.sc.sicanet.migracion_sicanet.service;

import com.sc.sicanet.migracion_sicanet.DTO.LaboralDTO;
import com.sc.sicanet.migracion_sicanet.entity.CatTipoOcupacion;
import com.sc.sicanet.migracion_sicanet.entity.Domicilio;
import com.sc.sicanet.migracion_sicanet.entity.Laboral;
import com.sc.sicanet.migracion_sicanet.entity.Persona;
import com.sc.sicanet.migracion_sicanet.entity.PldGiroActividad;
import com.sc.sicanet.migracion_sicanet.repository.CatTipoOcupacionRepository;
import com.sc.sicanet.migracion_sicanet.repository.LaboralRepository;
import com.sc.sicanet.migracion_sicanet.repository.PldGiroActividadRepository;
import com.sc.sicanet.migracion_sicanet.service.LaboralService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LaboralServiceImpl
implements LaboralService {
    @Autowired
    private LaboralRepository laboralRepository;
    @Autowired
    private CatTipoOcupacionRepository catTipoOcupacionRepository;
    @Autowired
    private PldGiroActividadRepository pldGiroActividadRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Optional<Laboral> consultaLaboral(Persona persona, Domicilio domicilio, String estatus) {
        return this.laboralRepository.findByPersonaAndDomicilioAndEstatus(persona, domicilio, estatus);
    }

    @Override
    public Laboral guardarLaboral(Laboral laboral) {
        return (Laboral)this.laboralRepository.save(laboral);
    }

    @Override
    public Laboral convertirADatosDeLaboral(LaboralDTO laboralDTO, Persona persona, Domicilio domicilio) {
        Optional<Laboral> laboralExistente;
        LocalDateTime fechaHoraActual = LocalDateTime.now();
        LocalDate fechaActual = LocalDate.now();
        Optional<CatTipoOcupacion> catTipoOcupacion = this.catTipoOcupacionRepository.findByDescripcion(laboralDTO.getTipo_ocupacion());
        Optional<PldGiroActividad> pldGiroActividad = this.pldGiroActividadRepository.findByPkGiroActividad(laboralDTO.getActividad_economica());
        String tipoOcupacion = laboralDTO.getTipo_ocupacion().toUpperCase().trim();
        if (tipoOcupacion.equals("AMA DE CASA") || tipoOcupacion.equals("NINGUNO") || tipoOcupacion.equals("NO APLICA")) {
            boolean datosExtraIngresados;
            boolean bl = datosExtraIngresados = laboralDTO.getNombre_empresa() != null && !laboralDTO.getNombre_empresa().isBlank() || laboralDTO.getGiro_comercial() != null && !laboralDTO.getGiro_comercial().isBlank() || laboralDTO.getDepartamento() != null && !laboralDTO.getDepartamento().isBlank() || laboralDTO.getPuesto() != null && !laboralDTO.getPuesto().isBlank() || laboralDTO.getNumero_empleado() != null && !laboralDTO.getNumero_empleado().isBlank() || laboralDTO.getActividad_economica() != 0 && laboralDTO.getActividad_economica() != 0;
            if (datosExtraIngresados) {
                throw new IllegalArgumentException("No Se Deben Ingresar Datos Laborales Adicionales Cuando El Tipo De Ocupaci\u00f3n Es 'AMA DE CASA', 'NINGUNO' o 'NO APLICA'.");
            }
        }
        Laboral laboral = new Laboral(fechaHoraActual, catTipoOcupacion.isPresent() ? catTipoOcupacion.get().getAcronimo() : "", "", laboralDTO.getNombre_empresa(), laboralDTO.getGiro_comercial(), laboralDTO.getDepartamento(), laboralDTO.getPuesto(), laboralDTO.getNumero_empleado(), fechaActual, pldGiroActividad.isPresent() ? pldGiroActividad.get().getPkGiroActividad() : 0, "", "N", "N", 1, "API Migracion", "A", 1, "");
        laboral.setFechaControl(fechaHoraActual);
        laboral.setFechaRegistro(fechaHoraActual);
        if (persona.getPkPersona() != 0 && domicilio.getPkDomicilio() != 0 && !(laboralExistente = this.consultaLaboral(persona, domicilio, "A")).isEmpty()) {
            laboral.setPkLaboralSocio(laboralExistente.get().getPkLaboralSocio());
            laboral.setFechaControl(laboralExistente.get().getFechaControl());
            laboral.setFechaRegistro(laboralExistente.get().getFechaRegistro());
        }
        return laboral;
    }
}

