"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const install_1 = require("./install");
const xml_1 = require("./utils/xml");
const xslt_processor_1 = require("./xslt-processor");
// The exported entry point of the XSL-T processor, as explained
// above.
//
// @param xmlDoc The input document root, as DOM node.
// @param template The stylesheet document root, as DOM node.
// @return the processed document, as XML text in a string.
function xsltProcess(xmlDoc, stylesheet) {
    const processor = new xslt_processor_1.XSLTProcessorImpl();
    processor.importStylesheet(stylesheet);
    const document = install_1.getDom().createDocument(null, null, null);
    const output = processor.transformToFragment(xmlDoc, document);
    const ret = xml_1.xmlText(output);
    return ret;
}
exports.xsltProcess = xsltProcess;
//# sourceMappingURL=api.js.map