"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const xpath_exception_1 = require("./xpath-exception");
const xpath_types_1 = require("./xpath-types");
class XPathResultImpl {
    constructor(v, t) {
        this.ANY_TYPE = XPathResultImpl.ANY_TYPE;
        this.NUMBER_TYPE = XPathResultImpl.NUMBER_TYPE;
        this.STRING_TYPE = XPathResultImpl.STRING_TYPE;
        this.BOOLEAN_TYPE = XPathResultImpl.BOOLEAN_TYPE;
        this.UNORDERED_NODE_ITERATOR_TYPE = XPathResultImpl.UNORDERED_NODE_ITERATOR_TYPE;
        this.ORDERED_NODE_ITERATOR_TYPE = XPathResultImpl.ORDERED_NODE_ITERATOR_TYPE;
        this.UNORDERED_NODE_SNAPSHOT_TYPE = XPathResultImpl.UNORDERED_NODE_SNAPSHOT_TYPE;
        this.ORDERED_NODE_SNAPSHOT_TYPE = XPathResultImpl.ORDERED_NODE_SNAPSHOT_TYPE;
        this.ANY_UNORDERED_NODE_TYPE = XPathResultImpl.ANY_UNORDERED_NODE_TYPE;
        this.FIRST_ORDERED_NODE_TYPE = XPathResultImpl.FIRST_ORDERED_NODE_TYPE;
        if (t === XPathResultImpl.ANY_TYPE) {
            if (v instanceof xpath_types_1.XString) {
                t = XPathResultImpl.STRING_TYPE;
            }
            else if (v instanceof xpath_types_1.XNumber) {
                t = XPathResultImpl.NUMBER_TYPE;
            }
            else if (v instanceof xpath_types_1.XBoolean) {
                t = XPathResultImpl.BOOLEAN_TYPE;
            }
            else if (v instanceof xpath_types_1.XNodeSet) {
                t = XPathResultImpl.UNORDERED_NODE_ITERATOR_TYPE;
            }
        }
        this.resultType = t;
        switch (t) {
            case XPathResultImpl.NUMBER_TYPE:
                this.numberValue = v.numberValue;
                this.stringValue = v.stringValue;
                this.booleanValue = v.booleanValue;
                return;
            case XPathResultImpl.STRING_TYPE:
                this.numberValue = v.numberValue;
                this.stringValue = v.stringValue;
                this.booleanValue = v.booleanValue;
                return;
            case XPathResultImpl.BOOLEAN_TYPE:
                this.numberValue = v.numberValue;
                this.stringValue = v.stringValue;
                this.booleanValue = v.booleanValue;
                return;
            case XPathResultImpl.ANY_UNORDERED_NODE_TYPE:
            case XPathResultImpl.FIRST_ORDERED_NODE_TYPE:
                if (v instanceof xpath_types_1.XNodeSet) {
                    const first = v.first();
                    this.singleNodeValue = first;
                    this.numberValue = v.numberValue;
                    this.stringValue = v.stringValue;
                    this.booleanValue = v.booleanValue;
                    this.nodes = first != null ? [first] : [];
                    return;
                }
                break;
            case XPathResultImpl.UNORDERED_NODE_ITERATOR_TYPE:
            case XPathResultImpl.ORDERED_NODE_ITERATOR_TYPE:
                if (v instanceof xpath_types_1.XNodeSet) {
                    this.invalidIteratorState = false;
                    this.nodes = v.toArray();
                    this.iteratorIndex = 0;
                    this.numberValue = v.numberValue;
                    this.stringValue = v.stringValue;
                    this.booleanValue = v.booleanValue;
                    return;
                }
                break;
            case XPathResultImpl.UNORDERED_NODE_SNAPSHOT_TYPE:
            case XPathResultImpl.ORDERED_NODE_SNAPSHOT_TYPE:
                if (v instanceof xpath_types_1.XNodeSet) {
                    this.nodes = v.toArray();
                    this.snapshotLength = this.nodes.length;
                    this.numberValue = v.numberValue;
                    this.stringValue = v.stringValue;
                    this.booleanValue = v.booleanValue;
                    return;
                }
                break;
        }
        throw new xpath_exception_1.XPathException(xpath_exception_1.XPathException.TYPE_ERR);
    }
    iterateNext() {
        if (this.resultType !== XPathResultImpl.UNORDERED_NODE_ITERATOR_TYPE &&
            this.resultType !== XPathResultImpl.ORDERED_NODE_ITERATOR_TYPE) {
            throw new xpath_exception_1.XPathException(xpath_exception_1.XPathException.TYPE_ERR);
        }
        if (this.iteratorIndex === this.nodes.length) {
            return null;
        }
        return this.nodes[this.iteratorIndex++];
    }
    snapshotItem(i) {
        if (this.resultType !== XPathResultImpl.UNORDERED_NODE_SNAPSHOT_TYPE &&
            this.resultType !== XPathResultImpl.ORDERED_NODE_SNAPSHOT_TYPE) {
            throw new xpath_exception_1.XPathException(xpath_exception_1.XPathException.TYPE_ERR);
        }
        return this.nodes[i];
    }
}
XPathResultImpl.ANY_TYPE = 0;
XPathResultImpl.NUMBER_TYPE = 1;
XPathResultImpl.STRING_TYPE = 2;
XPathResultImpl.BOOLEAN_TYPE = 3;
XPathResultImpl.UNORDERED_NODE_ITERATOR_TYPE = 4;
XPathResultImpl.ORDERED_NODE_ITERATOR_TYPE = 5;
XPathResultImpl.UNORDERED_NODE_SNAPSHOT_TYPE = 6;
XPathResultImpl.ORDERED_NODE_SNAPSHOT_TYPE = 7;
XPathResultImpl.ANY_UNORDERED_NODE_TYPE = 8;
XPathResultImpl.FIRST_ORDERED_NODE_TYPE = 9;
exports.XPathResultImpl = XPathResultImpl;
//# sourceMappingURL=xpath-result-impl.js.map