"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const function_call_1 = require("./function-call");
const location_path_1 = require("./location-path");
const node_test_1 = require("./node-test");
const and_operation_1 = require("./operations/and-operation");
const bar_operation_1 = require("./operations/bar-operation");
const div_operation_1 = require("./operations/div-operation");
const equals_operation_1 = require("./operations/equals-operation");
const greater_than_operation_1 = require("./operations/greater-than-operation");
const greater_than_or_equal_operation_1 = require("./operations/greater-than-or-equal-operation");
const less_than_operation_1 = require("./operations/less-than-operation");
const less_than_or_equal_operation_1 = require("./operations/less-than-or-equal-operation");
const minus_operation_1 = require("./operations/minus-operation");
const mod_operation_1 = require("./operations/mod-operation");
const multiply_operation_1 = require("./operations/multiply-operation");
const not_equals_operation_1 = require("./operations/not-equals-operation");
const or_operation_1 = require("./operations/or-operation");
const plus_operation_1 = require("./operations/plus-operation");
const unary_minus_operation_1 = require("./operations/unary-minus-operation");
const path_expr_1 = require("./path-expr");
const step_1 = require("./step");
const character_1 = require("./utils/character");
const variable_reference_1 = require("./variable-reference");
const xpath_1 = require("./xpath");
const xpath_exception_1 = require("./xpath-exception");
const xpath_types_1 = require("./xpath-types");
// tslint:disable:quotemark
class XPathParser {
    constructor() {
        this.reduceActions = [];
        this.reduceActions[3] = (rhs) => {
            return new or_operation_1.OrOperation(rhs[0], rhs[2]);
        };
        this.reduceActions[5] = (rhs) => {
            return new and_operation_1.AndOperation(rhs[0], rhs[2]);
        };
        this.reduceActions[7] = (rhs) => {
            return new equals_operation_1.EqualsOperation(rhs[0], rhs[2]);
        };
        this.reduceActions[8] = (rhs) => {
            return new not_equals_operation_1.NotEqualOperation(rhs[0], rhs[2]);
        };
        this.reduceActions[10] = (rhs) => {
            return new less_than_operation_1.LessThanOperation(rhs[0], rhs[2]);
        };
        this.reduceActions[11] = (rhs) => {
            return new greater_than_operation_1.GreaterThanOperation(rhs[0], rhs[2]);
        };
        this.reduceActions[12] = (rhs) => {
            return new less_than_or_equal_operation_1.LessThanOrEqualOperation(rhs[0], rhs[2]);
        };
        this.reduceActions[13] = (rhs) => {
            return new greater_than_or_equal_operation_1.GreaterThanOrEqualOperation(rhs[0], rhs[2]);
        };
        this.reduceActions[15] = (rhs) => {
            return new plus_operation_1.PlusOperation(rhs[0], rhs[2]);
        };
        this.reduceActions[16] = (rhs) => {
            return new minus_operation_1.MinusOperation(rhs[0], rhs[2]);
        };
        this.reduceActions[18] = (rhs) => {
            return new multiply_operation_1.MultiplyOperation(rhs[0], rhs[2]);
        };
        this.reduceActions[19] = (rhs) => {
            return new div_operation_1.DivOperation(rhs[0], rhs[2]);
        };
        this.reduceActions[20] = (rhs) => {
            return new mod_operation_1.ModOperation(rhs[0], rhs[2]);
        };
        this.reduceActions[22] = (rhs) => {
            return new unary_minus_operation_1.UnaryMinusOperation(rhs[1]);
        };
        this.reduceActions[24] = (rhs) => {
            return new bar_operation_1.BarOperation(rhs[0], rhs[2]);
        };
        this.reduceActions[25] = (rhs) => {
            return new path_expr_1.PathExpr(undefined, undefined, rhs[0]);
        };
        this.reduceActions[27] = (rhs) => {
            rhs[0].locationPath = rhs[2];
            return rhs[0];
        };
        this.reduceActions[28] = (rhs) => {
            rhs[0].locationPath = rhs[2];
            rhs[0].locationPath.steps.unshift(new step_1.Step(step_1.Step.DESCENDANTORSELF, node_test_1.NodeTest.nodeTest, []));
            return rhs[0];
        };
        this.reduceActions[29] = (rhs) => {
            return new path_expr_1.PathExpr(rhs[0], [], undefined);
        };
        this.reduceActions[30] = (rhs) => {
            if (rhs[0] instanceof path_expr_1.PathExpr) {
                if (rhs[0].filterPredicates === undefined) {
                    rhs[0].filterPredicates = [];
                }
                rhs[0].filterPredicates.push(rhs[1]);
                return rhs[0];
            }
            else {
                return new path_expr_1.PathExpr(rhs[0], [rhs[1]], undefined);
            }
        };
        this.reduceActions[32] = (rhs) => {
            return rhs[1];
        };
        this.reduceActions[33] = (rhs) => {
            return new xpath_types_1.XString(rhs[0]);
        };
        this.reduceActions[34] = (rhs) => {
            return new xpath_types_1.XNumber(rhs[0]);
        };
        this.reduceActions[36] = (rhs) => {
            return new function_call_1.FunctionCall(rhs[0], []);
        };
        this.reduceActions[37] = (rhs) => {
            return new function_call_1.FunctionCall(rhs[0], rhs[2]);
        };
        this.reduceActions[38] = (rhs) => {
            return [rhs[0]];
        };
        this.reduceActions[39] = (rhs) => {
            rhs[2].unshift(rhs[0]);
            return rhs[2];
        };
        this.reduceActions[43] = (_rhs) => {
            return new location_path_1.LocationPath(true, []);
        };
        this.reduceActions[44] = (rhs) => {
            rhs[1].absolute = true;
            return rhs[1];
        };
        this.reduceActions[46] = (rhs) => {
            return new location_path_1.LocationPath(false, [rhs[0]]);
        };
        this.reduceActions[47] = (rhs) => {
            rhs[0].steps.push(rhs[2]);
            return rhs[0];
        };
        this.reduceActions[49] = (rhs) => {
            return new step_1.Step(rhs[0], rhs[1], []);
        };
        this.reduceActions[50] = (rhs) => {
            return new step_1.Step(step_1.Step.CHILD, rhs[0], []);
        };
        this.reduceActions[51] = (rhs) => {
            return new step_1.Step(rhs[0], rhs[1], rhs[2]);
        };
        this.reduceActions[52] = (rhs) => {
            return new step_1.Step(step_1.Step.CHILD, rhs[0], rhs[1]);
        };
        this.reduceActions[54] = (rhs) => {
            return [rhs[0]];
        };
        this.reduceActions[55] = (rhs) => {
            rhs[1].unshift(rhs[0]);
            return rhs[1];
        };
        this.reduceActions[56] = (rhs) => {
            if (rhs[0] === 'ancestor') {
                return step_1.Step.ANCESTOR;
            }
            else if (rhs[0] === 'ancestor-or-self') {
                return step_1.Step.ANCESTORORSELF;
            }
            else if (rhs[0] === 'attribute') {
                return step_1.Step.ATTRIBUTE;
            }
            else if (rhs[0] === 'child') {
                return step_1.Step.CHILD;
            }
            else if (rhs[0] === 'descendant') {
                return step_1.Step.DESCENDANT;
            }
            else if (rhs[0] === 'descendant-or-self') {
                return step_1.Step.DESCENDANTORSELF;
            }
            else if (rhs[0] === 'following') {
                return step_1.Step.FOLLOWING;
            }
            else if (rhs[0] === 'following-sibling') {
                return step_1.Step.FOLLOWINGSIBLING;
            }
            else if (rhs[0] === 'namespace') {
                return step_1.Step.NAMESPACE;
            }
            else if (rhs[0] === 'parent') {
                return step_1.Step.PARENT;
            }
            else if (rhs[0] === 'preceding') {
                return step_1.Step.PRECEDING;
            }
            else if (rhs[0] === 'preceding-sibling') {
                return step_1.Step.PRECEDINGSIBLING;
            }
            else if (rhs[0] === 'self') {
                return step_1.Step.SELF;
            }
            return -1;
        };
        this.reduceActions[57] = (_rhs) => {
            return step_1.Step.ATTRIBUTE;
        };
        this.reduceActions[59] = (rhs) => {
            if (rhs[0] === 'comment') {
                return node_test_1.NodeTest.commentTest;
            }
            else if (rhs[0] === 'text') {
                return node_test_1.NodeTest.textTest;
            }
            else if (rhs[0] === 'processing-instruction') {
                return node_test_1.NodeTest.anyPiTest;
            }
            else if (rhs[0] === 'node') {
                return node_test_1.NodeTest.nodeTest;
            }
            return new node_test_1.NodeTest(-1);
        };
        this.reduceActions[60] = (rhs) => {
            return new node_test_1.NodeTest.PITest(rhs[2]);
        };
        this.reduceActions[61] = (rhs) => {
            return rhs[1];
        };
        this.reduceActions[63] = (rhs) => {
            rhs[1].absolute = true;
            rhs[1].steps.unshift(new step_1.Step(step_1.Step.DESCENDANTORSELF, node_test_1.NodeTest.nodeTest, []));
            return rhs[1];
        };
        this.reduceActions[64] = (rhs) => {
            rhs[0].steps.push(new step_1.Step(step_1.Step.DESCENDANTORSELF, node_test_1.NodeTest.nodeTest, []));
            rhs[0].steps.push(rhs[2]);
            return rhs[0];
        };
        this.reduceActions[65] = (_rhs) => {
            return new step_1.Step(step_1.Step.SELF, node_test_1.NodeTest.nodeTest, []);
        };
        this.reduceActions[66] = (_rhs) => {
            return new step_1.Step(step_1.Step.PARENT, node_test_1.NodeTest.nodeTest, []);
        };
        this.reduceActions[67] = (rhs) => {
            return new variable_reference_1.VariableReference(rhs[1]);
        };
        this.reduceActions[68] = (_rhs) => {
            return node_test_1.NodeTest.nameTestAny;
        };
        this.reduceActions[69] = (rhs) => {
            return new node_test_1.NodeTest.NameTestPrefixAny(rhs[0].split(':')[0]);
        };
        this.reduceActions[70] = (rhs) => {
            return new node_test_1.NodeTest.NameTestQName(rhs[0]);
        };
    }
    tokenize(s1) {
        const s = s1 + '\0';
        const types = [];
        const values = [];
        let pos = 0;
        let c = s.charAt(pos++);
        while (1) {
            while (c === ' ' || c === '\t' || c === '\r' || c === '\n') {
                c = s.charAt(pos++);
            }
            if (c === '\0' || pos >= s.length) {
                break;
            }
            if (c === '(') {
                types.push(XPathParser.LEFTPARENTHESIS);
                values.push(c);
                c = s.charAt(pos++);
                continue;
            }
            if (c === ')') {
                types.push(XPathParser.RIGHTPARENTHESIS);
                values.push(c);
                c = s.charAt(pos++);
                continue;
            }
            if (c === '[') {
                types.push(XPathParser.LEFTBRACKET);
                values.push(c);
                c = s.charAt(pos++);
                continue;
            }
            if (c === ']') {
                types.push(XPathParser.RIGHTBRACKET);
                values.push(c);
                c = s.charAt(pos++);
                continue;
            }
            if (c === '@') {
                types.push(XPathParser.AT);
                values.push(c);
                c = s.charAt(pos++);
                continue;
            }
            if (c === ',') {
                types.push(XPathParser.COMMA);
                values.push(c);
                c = s.charAt(pos++);
                continue;
            }
            if (c === '|') {
                types.push(XPathParser.BAR);
                values.push(c);
                c = s.charAt(pos++);
                continue;
            }
            if (c === '+') {
                types.push(XPathParser.PLUS);
                values.push(c);
                c = s.charAt(pos++);
                continue;
            }
            if (c === '-') {
                types.push(XPathParser.MINUS);
                values.push(c);
                c = s.charAt(pos++);
                continue;
            }
            if (c === '=') {
                types.push(XPathParser.EQUALS);
                values.push(c);
                c = s.charAt(pos++);
                continue;
            }
            if (c === '$') {
                types.push(XPathParser.DOLLAR);
                values.push(c);
                c = s.charAt(pos++);
                continue;
            }
            if (c === '.') {
                c = s.charAt(pos++);
                if (c === '.') {
                    types.push(XPathParser.DOUBLEDOT);
                    values.push('..');
                    c = s.charAt(pos++);
                    continue;
                }
                if (c >= '0' && c <= '9') {
                    let num = '.' + c;
                    c = s.charAt(pos++);
                    while (c >= '0' && c <= '9') {
                        num += c;
                        c = s.charAt(pos++);
                    }
                    types.push(XPathParser.NUMBER);
                    values.push(num);
                    continue;
                }
                types.push(XPathParser.DOT);
                values.push('.');
                continue;
            }
            if (c === "'" || c === '"') {
                const delimiter = c;
                let literal = '';
                // tslint:disable-next-line:no-conditional-assignment
                while (pos < s.length && (c = s.charAt(pos)) !== delimiter) {
                    literal += c;
                    pos += 1;
                }
                if (c !== delimiter) {
                    throw xpath_exception_1.XPathException.fromMessage('Unterminated string literal: ' + delimiter + literal);
                }
                pos += 1;
                types.push(XPathParser.LITERAL);
                values.push(literal);
                c = s.charAt(pos++);
                continue;
            }
            if (c >= '0' && c <= '9') {
                let num = c;
                c = s.charAt(pos++);
                while (c >= '0' && c <= '9') {
                    num += c;
                    c = s.charAt(pos++);
                }
                if (c === '.') {
                    if (s.charAt(pos) >= '0' && s.charAt(pos) <= '9') {
                        num += c;
                        num += s.charAt(pos++);
                        c = s.charAt(pos++);
                        while (c >= '0' && c <= '9') {
                            num += c;
                            c = s.charAt(pos++);
                        }
                    }
                }
                types.push(XPathParser.NUMBER);
                values.push(num);
                continue;
            }
            if (c === '*') {
                if (types.length > 0) {
                    const last = types[types.length - 1];
                    if (last !== XPathParser.AT &&
                        last !== XPathParser.DOUBLECOLON &&
                        last !== XPathParser.LEFTPARENTHESIS &&
                        last !== XPathParser.LEFTBRACKET &&
                        last !== XPathParser.AND &&
                        last !== XPathParser.OR &&
                        last !== XPathParser.MOD &&
                        last !== XPathParser.DIV &&
                        last !== XPathParser.MULTIPLYOPERATOR &&
                        last !== XPathParser.SLASH &&
                        last !== XPathParser.DOUBLESLASH &&
                        last !== XPathParser.BAR &&
                        last !== XPathParser.PLUS &&
                        last !== XPathParser.MINUS &&
                        last !== XPathParser.EQUALS &&
                        last !== XPathParser.NOTEQUAL &&
                        last !== XPathParser.LESSTHAN &&
                        last !== XPathParser.LESSTHANOREQUAL &&
                        last !== XPathParser.GREATERTHAN &&
                        last !== XPathParser.GREATERTHANOREQUAL) {
                        types.push(XPathParser.MULTIPLYOPERATOR);
                        values.push(c);
                        c = s.charAt(pos++);
                        continue;
                    }
                }
                types.push(XPathParser.ASTERISKNAMETEST);
                values.push(c);
                c = s.charAt(pos++);
                continue;
            }
            if (c === ':') {
                if (s.charAt(pos) === ':') {
                    types.push(XPathParser.DOUBLECOLON);
                    values.push('::');
                    pos++;
                    c = s.charAt(pos++);
                    continue;
                }
            }
            if (c === '/') {
                c = s.charAt(pos++);
                if (c === '/') {
                    types.push(XPathParser.DOUBLESLASH);
                    values.push('//');
                    c = s.charAt(pos++);
                    continue;
                }
                types.push(XPathParser.SLASH);
                values.push('/');
                continue;
            }
            if (c === '!') {
                if (s.charAt(pos) === '=') {
                    types.push(XPathParser.NOTEQUAL);
                    values.push('!=');
                    pos++;
                    c = s.charAt(pos++);
                    continue;
                }
            }
            if (c === '<') {
                if (s.charAt(pos) === '=') {
                    types.push(XPathParser.LESSTHANOREQUAL);
                    values.push('<=');
                    pos++;
                    c = s.charAt(pos++);
                    continue;
                }
                types.push(XPathParser.LESSTHAN);
                values.push('<');
                c = s.charAt(pos++);
                continue;
            }
            if (c === '>') {
                if (s.charAt(pos) === '=') {
                    types.push(XPathParser.GREATERTHANOREQUAL);
                    values.push('>=');
                    pos++;
                    c = s.charAt(pos++);
                    continue;
                }
                types.push(XPathParser.GREATERTHAN);
                values.push('>');
                c = s.charAt(pos++);
                continue;
            }
            if (c === '_' || character_1.isLetter(c.charCodeAt(0))) {
                let name = c;
                c = s.charAt(pos++);
                while (character_1.isNCNameChar(c.charCodeAt(0))) {
                    name += c;
                    c = s.charAt(pos++);
                }
                if (types.length > 0) {
                    const last = types[types.length - 1];
                    if (last !== XPathParser.AT &&
                        last !== XPathParser.DOUBLECOLON &&
                        last !== XPathParser.LEFTPARENTHESIS &&
                        last !== XPathParser.LEFTBRACKET &&
                        last !== XPathParser.AND &&
                        last !== XPathParser.OR &&
                        last !== XPathParser.MOD &&
                        last !== XPathParser.DIV &&
                        last !== XPathParser.MULTIPLYOPERATOR &&
                        last !== XPathParser.SLASH &&
                        last !== XPathParser.DOUBLESLASH &&
                        last !== XPathParser.BAR &&
                        last !== XPathParser.PLUS &&
                        last !== XPathParser.MINUS &&
                        last !== XPathParser.EQUALS &&
                        last !== XPathParser.NOTEQUAL &&
                        last !== XPathParser.LESSTHAN &&
                        last !== XPathParser.LESSTHANOREQUAL &&
                        last !== XPathParser.GREATERTHAN &&
                        last !== XPathParser.GREATERTHANOREQUAL) {
                        if (name === 'and') {
                            types.push(XPathParser.AND);
                            values.push(name);
                            continue;
                        }
                        if (name === 'or') {
                            types.push(XPathParser.OR);
                            values.push(name);
                            continue;
                        }
                        if (name === 'mod') {
                            types.push(XPathParser.MOD);
                            values.push(name);
                            continue;
                        }
                        if (name === 'div') {
                            types.push(XPathParser.DIV);
                            values.push(name);
                            continue;
                        }
                    }
                }
                if (c === ':') {
                    if (s.charAt(pos) === '*') {
                        types.push(XPathParser.NCNAMECOLONASTERISK);
                        values.push(name + ':*');
                        pos++;
                        c = s.charAt(pos++);
                        continue;
                    }
                    if (s.charAt(pos) === '_' || character_1.isLetter(s.charCodeAt(pos))) {
                        name += ':';
                        c = s.charAt(pos++);
                        while (character_1.isNCNameChar(c.charCodeAt(0))) {
                            name += c;
                            c = s.charAt(pos++);
                        }
                        if (c === '(') {
                            types.push(XPathParser.FUNCTIONNAME);
                            values.push(name);
                            continue;
                        }
                        types.push(XPathParser.QNAME);
                        values.push(name);
                        continue;
                    }
                    if (s.charAt(pos) === ':') {
                        types.push(XPathParser.AXISNAME);
                        values.push(name);
                        continue;
                    }
                }
                if (c === '(') {
                    if (name === 'comment' || name === 'text' || name === 'node') {
                        types.push(XPathParser.NODETYPE);
                        values.push(name);
                        continue;
                    }
                    if (name === 'processing-instruction') {
                        if (s.charAt(pos) === ')') {
                            types.push(XPathParser.NODETYPE);
                        }
                        else {
                            types.push(XPathParser.PROCESSINGINSTRUCTIONWITHLITERAL);
                        }
                        values.push(name);
                        continue;
                    }
                    types.push(XPathParser.FUNCTIONNAME);
                    values.push(name);
                    continue;
                }
                types.push(XPathParser.QNAME);
                values.push(name);
                continue;
            }
            throw new Error('Unexpected character ' + c);
        }
        types.push(1);
        values.push('[EOF]');
        return [types, values];
    }
    parse(str) {
        const res = this.tokenize(str);
        const types = res[0];
        const values = res[1];
        let tokenPos = 0;
        const state = [];
        const tokenType = [];
        const tokenValue = [];
        let s;
        let a;
        let t;
        state.push(0);
        tokenType.push(1);
        tokenValue.push('_S');
        a = types[tokenPos];
        t = values[tokenPos++];
        while (1) {
            s = state[state.length - 1];
            switch (XPathParser.actionTable[s].charAt(a - 1)) {
                case XPathParser.SHIFT:
                    tokenType.push(-a);
                    tokenValue.push(t);
                    state.push(XPathParser.actionTableNumber[s].charCodeAt(a - 1) - 32);
                    a = types[tokenPos];
                    t = values[tokenPos++];
                    break;
                case XPathParser.REDUCE:
                    const num = XPathParser.productions[XPathParser.actionTableNumber[s].charCodeAt(a - 1) - 32][1];
                    const rhs = [];
                    for (let i = 0; i < num; i++) {
                        tokenType.pop();
                        rhs.unshift(tokenValue.pop());
                        state.pop();
                    }
                    const lastState = state[state.length - 1];
                    tokenType.push(XPathParser.productions[XPathParser.actionTableNumber[s].charCodeAt(a - 1) - 32][0]);
                    if (this.reduceActions[XPathParser.actionTableNumber[s].charCodeAt(a - 1) - 32] === undefined) {
                        tokenValue.push(rhs[0]);
                    }
                    else {
                        tokenValue.push(this.reduceActions[XPathParser.actionTableNumber[s].charCodeAt(a - 1) - 32](rhs));
                    }
                    state.push(XPathParser.gotoTable[lastState].charCodeAt(XPathParser.productions[XPathParser.actionTableNumber[s].charCodeAt(a - 1) - 32][0] - 2) - 33);
                    break;
                case XPathParser.ACCEPT:
                    const expr = tokenValue.pop();
                    if (!(expr instanceof xpath_types_1.Expression)) {
                        throw new Error('XPath parse error. Wrong result type.');
                    }
                    return new xpath_1.XPath(expr);
                default:
                    throw new Error('XPath parse error');
            }
        }
        throw new Error('XPath parse error');
    }
}
XPathParser.actionTable = [
    ' s s        sssssssss    s ss  s  ss',
    '                 s                  ',
    'r  rrrrrrrrr         rrrrrrr rr  r  ',
    '                rrrrr               ',
    ' s s        sssssssss    s ss  s  ss',
    'rs  rrrrrrrr s  sssssrrrrrr  rrs rs ',
    ' s s        sssssssss    s ss  s  ss',
    '                            s       ',
    '                            s       ',
    'r  rrrrrrrrr         rrrrrrr rr rr  ',
    'r  rrrrrrrrr         rrrrrrr rr rr  ',
    'r  rrrrrrrrr         rrrrrrr rr rr  ',
    'r  rrrrrrrrr         rrrrrrr rr rr  ',
    'r  rrrrrrrrr         rrrrrrr rr rr  ',
    '  s                                 ',
    '                            s       ',
    ' s           s  sssss          s  s ',
    'r  rrrrrrrrr         rrrrrrr rr  r  ',
    'a                                   ',
    'r       s                    rr  r  ',
    'r      sr                    rr  r  ',
    'r   s  rr            s       rr  r  ',
    'r   rssrr            rss     rr  r  ',
    'r   rrrrr            rrrss   rr  r  ',
    'r   rrrrrsss         rrrrr   rr  r  ',
    'r   rrrrrrrr         rrrrr   rr  r  ',
    'r   rrrrrrrr         rrrrrs  rr  r  ',
    'r   rrrrrrrr         rrrrrr  rr  r  ',
    'r   rrrrrrrr         rrrrrr  rr  r  ',
    'r  srrrrrrrr         rrrrrrs rr sr  ',
    'r  srrrrrrrr         rrrrrrs rr  r  ',
    'r  rrrrrrrrr         rrrrrrr rr rr  ',
    'r  rrrrrrrrr         rrrrrrr rr rr  ',
    'r  rrrrrrrrr         rrrrrrr rr rr  ',
    'r   rrrrrrrr         rrrrrr  rr  r  ',
    'r   rrrrrrrr         rrrrrr  rr  r  ',
    'r  rrrrrrrrr         rrrrrrr rr  r  ',
    'r  rrrrrrrrr         rrrrrrr rr  r  ',
    '                sssss               ',
    'r  rrrrrrrrr         rrrrrrr rr sr  ',
    'r  rrrrrrrrr         rrrrrrr rr  r  ',
    'r  rrrrrrrrr         rrrrrrr rr rr  ',
    'r  rrrrrrrrr         rrrrrrr rr rr  ',
    '                             s      ',
    'r  srrrrrrrr         rrrrrrs rr  r  ',
    'r   rrrrrrrr         rrrrr   rr  r  ',
    '              s                     ',
    '                             s      ',
    '                rrrrr               ',
    ' s s        sssssssss    s sss s  ss',
    'r  srrrrrrrr         rrrrrrs rr  r  ',
    ' s s        sssssssss    s ss  s  ss',
    ' s s        sssssssss    s ss  s  ss',
    ' s s        sssssssss    s ss  s  ss',
    ' s s        sssssssss    s ss  s  ss',
    ' s s        sssssssss    s ss  s  ss',
    ' s s        sssssssss    s ss  s  ss',
    ' s s        sssssssss    s ss  s  ss',
    ' s s        sssssssss    s ss  s  ss',
    ' s s        sssssssss    s ss  s  ss',
    ' s s        sssssssss    s ss  s  ss',
    ' s s        sssssssss    s ss  s  ss',
    ' s s        sssssssss    s ss  s  ss',
    ' s s        sssssssss    s ss  s  ss',
    ' s s        sssssssss      ss  s  ss',
    ' s s        sssssssss    s ss  s  ss',
    ' s           s  sssss          s  s ',
    ' s           s  sssss          s  s ',
    'r  rrrrrrrrr         rrrrrrr rr rr  ',
    ' s           s  sssss          s  s ',
    ' s           s  sssss          s  s ',
    'r  rrrrrrrrr         rrrrrrr rr sr  ',
    'r  rrrrrrrrr         rrrrrrr rr sr  ',
    'r  rrrrrrrrr         rrrrrrr rr  r  ',
    'r  rrrrrrrrr         rrrrrrr rr rr  ',
    '                             s      ',
    'r  rrrrrrrrr         rrrrrrr rr rr  ',
    'r  rrrrrrrrr         rrrrrrr rr rr  ',
    '                             rr     ',
    '                             s      ',
    '                             rs     ',
    'r      sr                    rr  r  ',
    'r   s  rr            s       rr  r  ',
    'r   rssrr            rss     rr  r  ',
    'r   rssrr            rss     rr  r  ',
    'r   rrrrr            rrrss   rr  r  ',
    'r   rrrrr            rrrss   rr  r  ',
    'r   rrrrr            rrrss   rr  r  ',
    'r   rrrrr            rrrss   rr  r  ',
    'r   rrrrrsss         rrrrr   rr  r  ',
    'r   rrrrrsss         rrrrr   rr  r  ',
    'r   rrrrrrrr         rrrrr   rr  r  ',
    'r   rrrrrrrr         rrrrr   rr  r  ',
    'r   rrrrrrrr         rrrrr   rr  r  ',
    'r   rrrrrrrr         rrrrrr  rr  r  ',
    '                                 r  ',
    '                                 s  ',
    'r  srrrrrrrr         rrrrrrs rr  r  ',
    'r  srrrrrrrr         rrrrrrs rr  r  ',
    'r  rrrrrrrrr         rrrrrrr rr  r  ',
    'r  rrrrrrrrr         rrrrrrr rr  r  ',
    'r  rrrrrrrrr         rrrrrrr rr  r  ',
    'r  rrrrrrrrr         rrrrrrr rr  r  ',
    'r  rrrrrrrrr         rrrrrrr rr rr  ',
    'r  rrrrrrrrr         rrrrrrr rr rr  ',
    ' s s        sssssssss    s ss  s  ss',
    'r  rrrrrrrrr         rrrrrrr rr rr  ',
    '                             r      '
];
XPathParser.actionTableNumber = [
    ' 1 0        /.-,+*)(\'    & %$  #  "!',
    '                 J                  ',
    'a  aaaaaaaaa         aaaaaaa aa  a  ',
    '                YYYYY               ',
    ' 1 0        /.-,+*)(\'    & %$  #  "!',
    'K1  KKKKKKKK .  +*)(\'KKKKKK  KK# K" ',
    ' 1 0        /.-,+*)(\'    & %$  #  "!',
    '                            N       ',
    '                            O       ',
    'e  eeeeeeeee         eeeeeee ee ee  ',
    'f  fffffffff         fffffff ff ff  ',
    'd  ddddddddd         ddddddd dd dd  ',
    'B  BBBBBBBBB         BBBBBBB BB BB  ',
    'A  AAAAAAAAA         AAAAAAA AA AA  ',
    '  P                                 ',
    '                            Q       ',
    ' 1           .  +*)(\'          #  " ',
    'b  bbbbbbbbb         bbbbbbb bb  b  ',
    '                                    ',
    '!       S                    !!  !  ',
    '"      T"                    ""  "  ',
    '$   V  $$            U       $$  $  ',
    '&   &ZY&&            &XW     &&  &  ',
    ')   )))))            )))\\[   ))  )  ',
    '.   ....._^]         .....   ..  .  ',
    '1   11111111         11111   11  1  ',
    '5   55555555         55555`  55  5  ',
    '7   77777777         777777  77  7  ',
    '9   99999999         999999  99  9  ',
    ':  c::::::::         ::::::b :: a:  ',
    'I  fIIIIIIII         IIIIIIe II  I  ',
    '=  =========         ======= == ==  ',
    '?  ?????????         ??????? ?? ??  ',
    'C  CCCCCCCCC         CCCCCCC CC CC  ',
    'J   JJJJJJJJ         JJJJJJ  JJ  J  ',
    'M   MMMMMMMM         MMMMMM  MM  M  ',
    'N  NNNNNNNNN         NNNNNNN NN  N  ',
    'P  PPPPPPPPP         PPPPPPP PP  P  ',
    "                +*)('               ",
    'R  RRRRRRRRR         RRRRRRR RR aR  ',
    'U  UUUUUUUUU         UUUUUUU UU  U  ',
    'Z  ZZZZZZZZZ         ZZZZZZZ ZZ ZZ  ',
    'c  ccccccccc         ccccccc cc cc  ',
    '                             j      ',
    'L  fLLLLLLLL         LLLLLLe LL  L  ',
    '6   66666666         66666   66  6  ',
    '              k                     ',
    '                             l      ',
    '                XXXXX               ',
    ' 1 0        /.-,+*)(\'    & %$m #  "!',
    '_  f________         ______e __  _  ',
    ' 1 0        /.-,+*)(\'    & %$  #  "!',
    ' 1 0        /.-,+*)(\'    & %$  #  "!',
    ' 1 0        /.-,+*)(\'    & %$  #  "!',
    ' 1 0        /.-,+*)(\'    & %$  #  "!',
    ' 1 0        /.-,+*)(\'    & %$  #  "!',
    ' 1 0        /.-,+*)(\'    & %$  #  "!',
    ' 1 0        /.-,+*)(\'    & %$  #  "!',
    ' 1 0        /.-,+*)(\'    & %$  #  "!',
    ' 1 0        /.-,+*)(\'    & %$  #  "!',
    ' 1 0        /.-,+*)(\'    & %$  #  "!',
    ' 1 0        /.-,+*)(\'    & %$  #  "!',
    ' 1 0        /.-,+*)(\'    & %$  #  "!',
    ' 1 0        /.-,+*)(\'    & %$  #  "!',
    ' 1 0        /.-,+*)(\'      %$  #  "!',
    ' 1 0        /.-,+*)(\'    & %$  #  "!',
    ' 1           .  +*)(\'          #  " ',
    ' 1           .  +*)(\'          #  " ',
    '>  >>>>>>>>>         >>>>>>> >> >>  ',
    ' 1           .  +*)(\'          #  " ',
    ' 1           .  +*)(\'          #  " ',
    'Q  QQQQQQQQQ         QQQQQQQ QQ aQ  ',
    'V  VVVVVVVVV         VVVVVVV VV aV  ',
    'T  TTTTTTTTT         TTTTTTT TT  T  ',
    '@  @@@@@@@@@         @@@@@@@ @@ @@  ',
    '                             \x87      ',
    '[  [[[[[[[[[         [[[[[[[ [[ [[  ',
    'D  DDDDDDDDD         DDDDDDD DD DD  ',
    '                             HH     ',
    '                             \x88      ',
    '                             F\x89     ',
    '#      T#                    ##  #  ',
    '%   V  %%            U       %%  %  ',
    "'   'ZY''            'XW     ''  '  ",
    '(   (ZY((            (XW     ((  (  ',
    '+   +++++            +++\\[   ++  +  ',
    '*   *****            ***\\[   **  *  ',
    '-   -----            ---\\[   --  -  ',
    ',   ,,,,,            ,,,\\[   ,,  ,  ',
    '0   00000_^]         00000   00  0  ',
    '/   /////_^]         /////   //  /  ',
    '2   22222222         22222   22  2  ',
    '3   33333333         33333   33  3  ',
    '4   44444444         44444   44  4  ',
    '8   88888888         888888  88  8  ',
    '                                 ^  ',
    '                                 \x8a  ',
    ';  f;;;;;;;;         ;;;;;;e ;;  ;  ',
    '<  f<<<<<<<<         <<<<<<e <<  <  ',
    'O  OOOOOOOOO         OOOOOOO OO  O  ',
    '`  `````````         ``````` ``  `  ',
    'S  SSSSSSSSS         SSSSSSS SS  S  ',
    'W  WWWWWWWWW         WWWWWWW WW  W  ',
    '\\  \\\\\\\\\\\\\\\\\\         \\\\\\\\\\\\\\ \\\\ \\\\  ',
    'E  EEEEEEEEE         EEEEEEE EE EE  ',
    ' 1 0        /.-,+*)(\'    & %$  #  "!',
    ']  ]]]]]]]]]         ]]]]]]] ]] ]]  ',
    '                             G      '
];
XPathParser.gotoTable = [
    '3456789:;<=>?@ AB  CDEFGH IJ ',
    '                             ',
    '                             ',
    '                             ',
    'L456789:;<=>?@ AB  CDEFGH IJ ',
    '            M        EFGH IJ ',
    '       N;<=>?@ AB  CDEFGH IJ ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '            S        EFGH IJ ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '              e              ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                        h  J ',
    '              i          j   ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    'o456789:;<=>?@ ABpqCDEFGH IJ ',
    '                             ',
    '  r6789:;<=>?@ AB  CDEFGH IJ ',
    '   s789:;<=>?@ AB  CDEFGH IJ ',
    '    t89:;<=>?@ AB  CDEFGH IJ ',
    '    u89:;<=>?@ AB  CDEFGH IJ ',
    '     v9:;<=>?@ AB  CDEFGH IJ ',
    '     w9:;<=>?@ AB  CDEFGH IJ ',
    '     x9:;<=>?@ AB  CDEFGH IJ ',
    '     y9:;<=>?@ AB  CDEFGH IJ ',
    '      z:;<=>?@ AB  CDEFGH IJ ',
    '      {:;<=>?@ AB  CDEFGH IJ ',
    '       |;<=>?@ AB  CDEFGH IJ ',
    '       };<=>?@ AB  CDEFGH IJ ',
    '       ~;<=>?@ AB  CDEFGH IJ ',
    '         \x7f=>?@ AB  CDEFGH IJ ',
    '\x80456789:;<=>?@ AB  CDEFGH IJ\x81',
    '            \x82        EFGH IJ ',
    '            \x83        EFGH IJ ',
    '                             ',
    '                     \x84 GH IJ ',
    '                     \x85 GH IJ ',
    '              i          \x86   ',
    '              i          \x87   ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    '                             ',
    'o456789:;<=>?@ AB\x8cqCDEFGH IJ ',
    '                             ',
    '                             '
];
XPathParser.productions = [
    [1, 1, 2],
    [2, 1, 3],
    [3, 1, 4],
    [3, 3, 3, -9, 4],
    [4, 1, 5],
    [4, 3, 4, -8, 5],
    [5, 1, 6],
    [5, 3, 5, -22, 6],
    [5, 3, 5, -5, 6],
    [6, 1, 7],
    [6, 3, 6, -23, 7],
    [6, 3, 6, -24, 7],
    [6, 3, 6, -6, 7],
    [6, 3, 6, -7, 7],
    [7, 1, 8],
    [7, 3, 7, -25, 8],
    [7, 3, 7, -26, 8],
    [8, 1, 9],
    [8, 3, 8, -12, 9],
    [8, 3, 8, -11, 9],
    [8, 3, 8, -10, 9],
    [9, 1, 10],
    [9, 2, -26, 9],
    [10, 1, 11],
    [10, 3, 10, -27, 11],
    [11, 1, 12],
    [11, 1, 13],
    [11, 3, 13, -28, 14],
    [11, 3, 13, -4, 14],
    [13, 1, 15],
    [13, 2, 13, 16],
    [15, 1, 17],
    [15, 3, -29, 2, -30],
    [15, 1, -15],
    [15, 1, -16],
    [15, 1, 18],
    [18, 3, -13, -29, -30],
    [18, 4, -13, -29, 19, -30],
    [19, 1, 20],
    [19, 3, 20, -31, 19],
    [20, 1, 2],
    [12, 1, 14],
    [12, 1, 21],
    [21, 1, -28],
    [21, 2, -28, 14],
    [21, 1, 22],
    [14, 1, 23],
    [14, 3, 14, -28, 23],
    [14, 1, 24],
    [23, 2, 25, 26],
    [23, 1, 26],
    [23, 3, 25, 26, 27],
    [23, 2, 26, 27],
    [23, 1, 28],
    [27, 1, 16],
    [27, 2, 16, 27],
    [25, 2, -14, -3],
    [25, 1, -32],
    [26, 1, 29],
    [26, 3, -20, -29, -30],
    [26, 4, -21, -29, -15, -30],
    [16, 3, -33, 30, -34],
    [30, 1, 2],
    [22, 2, -4, 14],
    [24, 3, 14, -4, 23],
    [28, 1, -35],
    [28, 1, -2],
    [17, 2, -36, -18],
    [29, 1, -17],
    [29, 1, -19],
    [29, 1, -18]
];
XPathParser.DOUBLEDOT = 2;
XPathParser.DOUBLECOLON = 3;
XPathParser.DOUBLESLASH = 4;
XPathParser.NOTEQUAL = 5;
XPathParser.LESSTHANOREQUAL = 6;
XPathParser.GREATERTHANOREQUAL = 7;
XPathParser.AND = 8;
XPathParser.OR = 9;
XPathParser.MOD = 10;
XPathParser.DIV = 11;
XPathParser.MULTIPLYOPERATOR = 12;
XPathParser.FUNCTIONNAME = 13;
XPathParser.AXISNAME = 14;
XPathParser.LITERAL = 15;
XPathParser.NUMBER = 16;
XPathParser.ASTERISKNAMETEST = 17;
XPathParser.QNAME = 18;
XPathParser.NCNAMECOLONASTERISK = 19;
XPathParser.NODETYPE = 20;
XPathParser.PROCESSINGINSTRUCTIONWITHLITERAL = 21;
XPathParser.EQUALS = 22;
XPathParser.LESSTHAN = 23;
XPathParser.GREATERTHAN = 24;
XPathParser.PLUS = 25;
XPathParser.MINUS = 26;
XPathParser.BAR = 27;
XPathParser.SLASH = 28;
XPathParser.LEFTPARENTHESIS = 29;
XPathParser.RIGHTPARENTHESIS = 30;
XPathParser.COMMA = 31;
XPathParser.AT = 32;
XPathParser.LEFTBRACKET = 33;
XPathParser.RIGHTBRACKET = 34;
XPathParser.DOT = 35;
XPathParser.DOLLAR = 36;
XPathParser.SHIFT = 's';
XPathParser.REDUCE = 'r';
XPathParser.ACCEPT = 'a';
exports.XPathParser = XPathParser;
//# sourceMappingURL=xpath-parser.js.map