"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const types_1 = require("./utils/types");
class XPathNSResolverWrapper {
    constructor(r) {
        if (!types_1.isNSResolver(r)) {
            this.xpathNSResolver = null;
        }
        else {
            this.xpathNSResolver = r;
        }
    }
    getNamespace(prefix, _n) {
        if (this.xpathNSResolver == null) {
            return null;
        }
        return this.xpathNSResolver.lookupNamespaceURI(prefix);
    }
}
exports.XPathNSResolverWrapper = XPathNSResolverWrapper;
//# sourceMappingURL=xpath-ns-resolver-wrapper.js.map