"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class XPathException extends Error {
    constructor(code, error, message) {
        super(getMessage(code, error) || message);
        this.code = code;
        this.exception = error;
    }
    static fromMessage(message, error) {
        return new XPathException(undefined, error, message);
    }
    toString() {
        return this.message;
    }
}
XPathException.INVALID_EXPRESSION_ERR = 51;
XPathException.TYPE_ERR = 52;
exports.XPathException = XPathException;
function getMessage(code, exception) {
    const msg = exception ? ': ' + exception.toString() : '';
    switch (code) {
        case XPathException.INVALID_EXPRESSION_ERR:
            return 'Invalid expression' + msg;
        case XPathException.TYPE_ERR:
            return 'Type error' + msg;
    }
    return undefined;
}
//# sourceMappingURL=xpath-exception.js.map