"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function isElement(e) {
    return e != null && e.nodeType === 1; // Node.ELEMENT_NODE;
}
exports.isElement = isElement;
function isAttribute(e) {
    return e != null && (e.nodeType === 2 || e.specified); // Node.ATTRIBUTE_NODE; // DOM4 support
}
exports.isAttribute = isAttribute;
function isText(e) {
    return e != null && e.nodeType === 3; // Node.TEXT_NODE;
}
exports.isText = isText;
function isCData(e) {
    return e != null && e.nodeType === 4; // Node.CDATA_SECTION_NODE;
}
exports.isCData = isCData;
function isDocument(e) {
    return e != null && e.nodeType === 9; // Node.DOCUMENT_NODE;
}
exports.isDocument = isDocument;
function isFragment(e) {
    return e != null && e.nodeType === 11; // Node.DOCUMENT_FRAGMENT;
}
exports.isFragment = isFragment;
function isProcessingInstruction(e) {
    return e != null && e.nodeType === 7; // Node.PROCESSING_INSTRUCTION_NODE;
}
exports.isProcessingInstruction = isProcessingInstruction;
function isNamespaceNode(e) {
    if (isAttribute(e)) {
        return e.localName === 'xmlns' || e.prefix === 'xmlns';
    }
    else {
        return false;
    }
}
exports.isNamespaceNode = isNamespaceNode;
function isNSResolver(r) {
    return r != null && r.lookupNamespaceURI !== undefined;
}
exports.isNSResolver = isNSResolver;
//# sourceMappingURL=types.js.map