"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class Step {
    constructor(axis, nodetest, preds) {
        this.axis = axis;
        this.nodeTest = nodetest;
        this.predicates = preds;
    }
    toString() {
        return Step.STEPNAMES[this.axis] + '::' + this.nodeTest.toString() + Step.predicatesString(this.predicates);
    }
}
Step.ANCESTOR = 0;
Step.ANCESTORORSELF = 1;
Step.ATTRIBUTE = 2;
Step.CHILD = 3;
Step.DESCENDANT = 4;
Step.DESCENDANTORSELF = 5;
Step.FOLLOWING = 6;
Step.FOLLOWINGSIBLING = 7;
Step.NAMESPACE = 8;
Step.PARENT = 9;
Step.PRECEDING = 10;
Step.PRECEDINGSIBLING = 11;
Step.SELF = 12;
Step.STEPNAMES = [
    [Step.ANCESTOR, 'ancestor'],
    [Step.ANCESTORORSELF, 'ancestor-or-self'],
    [Step.ATTRIBUTE, 'attribute'],
    [Step.CHILD, 'child'],
    [Step.DESCENDANT, 'descendant'],
    [Step.DESCENDANTORSELF, 'descendant-or-self'],
    [Step.FOLLOWING, 'following'],
    [Step.FOLLOWINGSIBLING, 'following-sibling'],
    [Step.NAMESPACE, 'namespace'],
    [Step.PARENT, 'parent'],
    [Step.PRECEDING, 'preceding'],
    [Step.PRECEDINGSIBLING, 'preceding-sibling'],
    [Step.SELF, 'self']
].reduce((acc, x) => {
    return (acc[x[0]] = x[1]), acc;
}, {});
Step.predicateString = (e) => `[${e.toString()}]`;
Step.predicatesString = (es) => es.map(Step.predicateString).join('');
exports.Step = Step;
//# sourceMappingURL=step.js.map