"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const binary_operation_1 = require("./binary-operation");
class OrOperation extends binary_operation_1.BinaryOperation {
    evaluate(c) {
        const b = this.lhs.evaluate(c).bool;
        if (b.booleanValue) {
            return b;
        }
        return this.rhs.evaluate(c).bool;
    }
    toString() {
        return '(' + this.lhs.toString() + ' or ' + this.rhs.toString() + ')';
    }
}
exports.OrOperation = OrOperation;
//# sourceMappingURL=or-operation.js.map