"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const binary_operation_1 = require("./binary-operation");
class MultiplyOperation extends binary_operation_1.BinaryOperation {
    evaluate(c) {
        return this.lhs.evaluate(c).number.multiply(this.rhs.evaluate(c).number);
    }
    toString() {
        return '(' + this.lhs.toString() + ' * ' + this.rhs.toString() + ')';
    }
}
exports.MultiplyOperation = MultiplyOperation;
//# sourceMappingURL=multiply-operation.js.map