"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const consts_1 = require("./consts");
const path_expr_1 = require("./path-expr");
const types_1 = require("./utils/types");
class NamespaceResolverImpl {
    getNamespace(prefix, n) {
        if (prefix === 'xml') {
            return consts_1.XML_NAMESPACE_URI;
        }
        else if (prefix === 'xmlns') {
            return consts_1.XMLNS_NAMESPACE_URI;
        }
        if (types_1.isDocument(n)) {
            n = n.documentElement;
        }
        else if (types_1.isAttribute(n)) {
            n = path_expr_1.PathExpr.getOwnerElement(n);
        }
        while (n != null && types_1.isElement(n)) {
            const nnm = n.attributes;
            for (let i = 0; i < nnm.length; i++) {
                const a = nnm.item(i);
                const aname = a.name || a.nodeName;
                if ((aname === 'xmlns' && prefix === '') || aname === 'xmlns:' + prefix) {
                    return String(a.value || a.nodeValue);
                }
            }
            n = n.parentNode;
        }
        return null;
    }
}
exports.NamespaceResolverImpl = NamespaceResolverImpl;
//# sourceMappingURL=namespace-resolver.js.map