"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const function_resolver_1 = require("./function-resolver");
const xpath_types_1 = require("./xpath-types");
class FunctionCall extends xpath_types_1.Expression {
    constructor(fn, args) {
        super();
        this.functionName = fn;
        this.arguments = args;
    }
    evaluate(c) {
        const f = function_resolver_1.FunctionResolverImpl.getFunctionFromContext(this.functionName, c);
        if (f === undefined) {
            throw new Error('Unknown function ' + this.functionName);
        }
        return f(c, ...this.arguments);
    }
    toString() {
        const args = this.arguments.map((a) => a.toString()).join(', ');
        return `${this.functionName}(${args})`;
    }
}
exports.FunctionCall = FunctionCall;
//# sourceMappingURL=function-call.js.map