import { DOMHandler, ElementAttributes, ErrorHandler, Locator, MutableDocument } from '../types';
export declare class DOMHandlerImpl implements DOMHandler, ErrorHandler {
    cdata: boolean;
    doc: MutableDocument;
    locator: Locator;
    currentElement: Node | null;
    constructor();
    startDocument(): void;
    startElement(namespaceURI: string, localName: string, qName: string, attrs: ElementAttributes): void;
    endElement(_namespaceURI: string, _localName: string, _qName: string): void;
    startPrefixMapping(_prefix: string, _uri: string): void;
    endPrefixMapping(_prefix: string): void;
    processingInstruction(target: string, data: string): void;
    ignorableWhitespace(_ch: string, _start: number, _length: number): void;
    characters(chars: string, start: number, length: number): void;
    skippedEntity(_name: string): void;
    endDocument(): void;
    setDocumentLocator(locator: Locator): void;
    comment(chars: string, start: number, length: number): void;
    startCDATA(): void;
    endCDATA(): void;
    startDTD(name: string, publicId: string, systemId: string): void;
    endDTD(): void;
    warning(error: string): void;
    error(error: string): void;
    fatalError(error: string): void;
    appendElement(node: Node): void;
}
