import './types';
import { DummyNode } from './dummy/dummy-node';
import { NodeTypeTS } from './node-types';
import { NodeFilterTS, RegisteredObserver } from './types';
/**
 * @see http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/core.html#ID-1950641247
 */
export declare class NodeImpl extends DummyNode {
    static readonly ELEMENT_NODE = NodeTypeTS.ELEMENT_NODE;
    static readonly ATTRIBUTE_NODE = NodeTypeTS.ATTRIBUTE_NODE;
    static readonly TEXT_NODE = NodeTypeTS.TEXT_NODE;
    static readonly CDATA_SECTION_NODE = NodeTypeTS.CDATA_SECTION_NODE;
    static readonly ENTITY_REFERENCE_NODE = NodeTypeTS.ENTITY_REFERENCE_NODE;
    static readonly ENTITY_NODE = NodeTypeTS.ENTITY_NODE;
    static readonly PROCESSING_INSTRUCTION_NODE = NodeTypeTS.PROCESSING_INSTRUCTION_NODE;
    static readonly COMMENT_NODE = NodeTypeTS.COMMENT_NODE;
    static readonly DOCUMENT_NODE = NodeTypeTS.DOCUMENT_NODE;
    static readonly DOCUMENT_TYPE_NODE = NodeTypeTS.DOCUMENT_TYPE_NODE;
    static readonly DOCUMENT_FRAGMENT_NODE = NodeTypeTS.DOCUMENT_FRAGMENT_NODE;
    static readonly NOTATION_NODE = NodeTypeTS.NOTATION_NODE;
    readonly ELEMENT_NODE = NodeTypeTS.ELEMENT_NODE;
    readonly ATTRIBUTE_NODE = NodeTypeTS.ATTRIBUTE_NODE;
    readonly TEXT_NODE = NodeTypeTS.TEXT_NODE;
    readonly CDATA_SECTION_NODE = NodeTypeTS.CDATA_SECTION_NODE;
    readonly ENTITY_REFERENCE_NODE = NodeTypeTS.ENTITY_REFERENCE_NODE;
    readonly ENTITY_NODE = NodeTypeTS.ENTITY_NODE;
    readonly PROCESSING_INSTRUCTION_NODE = NodeTypeTS.PROCESSING_INSTRUCTION_NODE;
    readonly COMMENT_NODE = NodeTypeTS.COMMENT_NODE;
    readonly DOCUMENT_NODE = NodeTypeTS.DOCUMENT_NODE;
    readonly DOCUMENT_TYPE_NODE = NodeTypeTS.DOCUMENT_TYPE_NODE;
    readonly DOCUMENT_FRAGMENT_NODE = NodeTypeTS.DOCUMENT_FRAGMENT_NODE;
    readonly NOTATION_NODE = NodeTypeTS.NOTATION_NODE;
    observers: RegisteredObserver[];
    nodeType: number;
    nodeName: string;
    firstChild: ChildNode | null;
    lastChild: ChildNode | null;
    previousSibling: Node | null;
    nextSibling: ChildNode | null;
    parentNode: Node & ParentNode | null;
    childNodes: NodeListOf<ChildNode>;
    ownerDocument: Document;
    nodeValue: string | null;
    namespaceURI: string | null;
    prefix: string | null;
    lineNumber?: number;
    columnNumber?: number;
    addObserver(observer: MutationObserver, options: MutationObserverInit): boolean;
    delObserver(observer: MutationObserver): void;
    queueMutation(r: MutationRecord): void;
    insertBefore<T extends Node>(newChild: T, refChild: Node | null): T;
    replaceChild<T extends Node>(newChild: Node, oldChild: T): T;
    removeChild<T extends Node>(oldChild: T): T;
    appendChild<T extends Node>(newChild: T): T;
    hasChildNodes(): boolean;
    cloneNode<T extends Node>(deep: boolean): T;
    normalize(): void;
    isSupported(feature: string, version: string): true;
    hasAttributes(): boolean;
    lookupPrefix(namespaceURI: string): string | null;
    lookupNamespaceURI(prefix: string): string | null;
    isDefaultNamespace(namespaceURI: string): boolean;
    toString(isHtml?: boolean, nodeFilter?: NodeFilterTS): string;
    textContent: string | null;
    protected ownerDocumentInternal(): Document;
}
