import './types';
/**
 *
 * Objects implementing the NamedNodeMap interface are used to represent collections of nodes
 * that can be accessed by name. Note that NamedNodeMap does not inherit from NodeList;
 * NamedNodeMaps are not maintained in any particular order. Objects contained in an object
 * implementing NamedNodeMap may also be accessed by an ordinal index, but this is simply to
 * allow convenient enumeration of the contents of a NamedNodeMap, and does not imply that
 * the DOM specifies an order to these Nodes.
 *
 * NamedNodeMap objects in the DOM are live.
 * used for attributes or DocumentType entities
 */
export declare class NamedNodeMapImpl extends Array<Attr> implements NamedNodeMap {
    _ownerElement: Element;
    item(index: number): Attr;
    getNamedItem(key: string): Attr | null;
    setNamedItem(attr: Attr): Attr | null;
    setNamedItemNS(attr: Attr): Attr | null;
    removeNamedItem(key: string): Attr;
    removeNamedItemNS(namespaceURI: string, localName: string): Attr;
    getNamedItemNS(namespaceURI: string | null, localName: string): Attr | null;
}
