import '../types';
import { RegisteredObserver } from '../types';
export declare abstract class DummyNode implements Node {
    abstract observers: RegisteredObserver[];
    abstract ownerDocument: Document;
    abstract firstChild: ChildNode | null;
    abstract lastChild: ChildNode | null;
    abstract previousSibling: Node | null;
    abstract nextSibling: ChildNode | null;
    abstract parentNode: (Node & ParentNode) | null;
    abstract namespaceURI: string | null;
    abstract nodeName: string;
    abstract nodeType: number;
    abstract nodeValue: string | null;
    abstract childNodes: NodeListOf<ChildNode>;
    abstract ATTRIBUTE_NODE: number;
    abstract CDATA_SECTION_NODE: number;
    abstract COMMENT_NODE: number;
    abstract DOCUMENT_FRAGMENT_NODE: number;
    abstract DOCUMENT_NODE: number;
    abstract DOCUMENT_TYPE_NODE: number;
    abstract ELEMENT_NODE: number;
    abstract ENTITY_NODE: number;
    abstract ENTITY_REFERENCE_NODE: number;
    abstract NOTATION_NODE: number;
    abstract PROCESSING_INSTRUCTION_NODE: number;
    abstract TEXT_NODE: number;
    abstract addObserver(observer: MutationObserver, options: MutationObserverInit): boolean;
    abstract delObserver(observer: MutationObserver): void;
    readonly childElementCount: number;
    readonly children: HTMLCollection;
    readonly firstElementChild: Element | null;
    readonly lastElementChild: Element | null;
    append(..._nodes: Array<string | Node>): void;
    prepend(..._nodes: Array<string | Node>): void;
    querySelector(_selectors: any): any;
    querySelectorAll(_selectors: any): any;
    readonly baseURI: string;
    readonly isConnected: boolean;
    readonly parentElement: HTMLElement | null;
    readonly textContent: string | null;
    appendChild<T extends Node>(_newChild: T): T;
    cloneNode<T extends Node>(_deep?: boolean): T;
    compareDocumentPosition(_other: Node): number;
    contains(_other: Node | null): boolean;
    getRootNode(_options?: GetRootNodeOptions | undefined): Node;
    hasChildNodes(): boolean;
    insertBefore<T extends Node>(_newChild: T, _refChild: Node | null): T;
    isDefaultNamespace(_namespace: string | null): boolean;
    isEqualNode(_otherNode: Node | null): boolean;
    isSameNode(_otherNode: Node | null): boolean;
    lookupNamespaceURI(_prefix: string | null): string | null;
    lookupPrefix(_namespace: string | null): string | null;
    normalize(): void;
    removeChild<T extends Node>(_oldChild: T): T;
    replaceChild<T extends Node>(_newChild: Node, _oldChild: T): T;
    static readonly DOCUMENT_POSITION_CONTAINED_BY: number;
    static readonly DOCUMENT_POSITION_CONTAINS: number;
    static readonly DOCUMENT_POSITION_DISCONNECTED: number;
    static readonly DOCUMENT_POSITION_FOLLOWING: number;
    static readonly DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC: number;
    static readonly DOCUMENT_POSITION_PRECEDING: number;
    readonly DOCUMENT_POSITION_CONTAINED_BY: number;
    readonly DOCUMENT_POSITION_CONTAINS: number;
    readonly DOCUMENT_POSITION_DISCONNECTED: number;
    readonly DOCUMENT_POSITION_FOLLOWING: number;
    readonly DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC: number;
    readonly DOCUMENT_POSITION_PRECEDING: number;
    addEventListener(_type: string, _listener: EventListener | EventListenerObject | null, _options?: boolean | AddEventListenerOptions | undefined): void;
    dispatchEvent(_event: Event): boolean;
    removeEventListener(_type: string, _callback: EventListener | EventListenerObject | null, _options?: boolean | EventListenerOptions | undefined): void;
    after(..._nodes: Array<string | Node>): void;
    before(..._nodes: Array<string | Node>): void;
    remove(): void;
    replaceWith(..._nodes: Array<string | Node>): void;
}
