import '../types';
import { NodeImpl } from '../node';
export declare abstract class DummyDocument extends NodeImpl implements Document {
    ownerDocument: never;
    abstract doctype: DocumentType | null;
    abstract documentElement: HTMLElement;
    abstract documentURI: string;
    abstract implementation: DOMImplementation;
    abstract _inc: number;
    onabort: ((this: GlobalEventHandlers, ev: UIEvent) => any) | null;
    onanimationcancel: ((this: GlobalEventHandlers, ev: AnimationEvent) => any) | null;
    onanimationend: ((this: GlobalEventHandlers, ev: AnimationEvent) => any) | null;
    onanimationiteration: ((this: GlobalEventHandlers, ev: AnimationEvent) => any) | null;
    onanimationstart: ((this: GlobalEventHandlers, ev: AnimationEvent) => any) | null;
    onauxclick: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    onblur: ((this: GlobalEventHandlers, ev: FocusEvent) => any) | null;
    oncancel: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    oncanplay: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    oncanplaythrough: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    onchange: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    onclick: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;
    onclose: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    oncontextmenu: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;
    oncuechange: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    ondblclick: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;
    ondrag: ((this: GlobalEventHandlers, ev: DragEvent) => any) | null;
    ondragend: ((this: GlobalEventHandlers, ev: DragEvent) => any) | null;
    ondragenter: ((this: GlobalEventHandlers, ev: DragEvent) => any) | null;
    ondragexit: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    ondragleave: ((this: GlobalEventHandlers, ev: DragEvent) => any) | null;
    ondragover: ((this: GlobalEventHandlers, ev: DragEvent) => any) | null;
    ondragstart: ((this: GlobalEventHandlers, ev: DragEvent) => any) | null;
    ondrop: ((this: GlobalEventHandlers, ev: DragEvent) => any) | null;
    ondurationchange: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    onemptied: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    onended: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    onerror: OnErrorEventHandler;
    onfocus: ((this: GlobalEventHandlers, ev: FocusEvent) => any) | null;
    ongotpointercapture: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;
    oninput: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    oninvalid: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    onkeydown: ((this: GlobalEventHandlers, ev: KeyboardEvent) => any) | null;
    onkeypress: ((this: GlobalEventHandlers, ev: KeyboardEvent) => any) | null;
    onkeyup: ((this: GlobalEventHandlers, ev: KeyboardEvent) => any) | null;
    onload: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    onloadeddata: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    onloadedmetadata: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    onloadend: ((this: GlobalEventHandlers, ev: ProgressEvent) => any) | null;
    onloadstart: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    onlostpointercapture: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;
    onmousedown: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;
    onmouseenter: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;
    onmouseleave: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;
    onmousemove: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;
    onmouseout: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;
    onmouseover: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;
    onmouseup: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;
    onpause: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    onplay: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    onplaying: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    onpointercancel: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;
    onpointerdown: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;
    onpointerenter: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;
    onpointerleave: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;
    onpointermove: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;
    onpointerout: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;
    onpointerover: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;
    onpointerup: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;
    onprogress: ((this: GlobalEventHandlers, ev: ProgressEvent) => any) | null;
    onratechange: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    onreset: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    onresize: ((this: GlobalEventHandlers, ev: UIEvent) => any) | null;
    onscroll: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    onsecuritypolicyviolation: ((this: GlobalEventHandlers, ev: SecurityPolicyViolationEvent) => any) | null;
    onseeked: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    onseeking: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    onselect: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    onselectionchange: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    onselectstart: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    onstalled: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    onsubmit: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    onsuspend: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    ontimeupdate: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    ontoggle: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    ontouchcancel: ((this: GlobalEventHandlers, ev: TouchEvent) => any) | null;
    ontouchend: ((this: GlobalEventHandlers, ev: TouchEvent) => any) | null;
    ontouchmove: ((this: GlobalEventHandlers, ev: TouchEvent) => any) | null;
    ontouchstart: ((this: GlobalEventHandlers, ev: TouchEvent) => any) | null;
    ontransitioncancel: ((this: GlobalEventHandlers, ev: TransitionEvent) => any) | null;
    ontransitionend: ((this: GlobalEventHandlers, ev: TransitionEvent) => any) | null;
    ontransitionrun: ((this: GlobalEventHandlers, ev: TransitionEvent) => any) | null;
    ontransitionstart: ((this: GlobalEventHandlers, ev: TransitionEvent) => any) | null;
    onvolumechange: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    onwaiting: ((this: GlobalEventHandlers, ev: Event) => any) | null;
    onwheel: ((this: GlobalEventHandlers, ev: WheelEvent) => any) | null;
    oncopy: ((this: DocumentAndElementEventHandlers, ev: ClipboardEvent) => any) | null;
    oncut: ((this: DocumentAndElementEventHandlers, ev: ClipboardEvent) => any) | null;
    onpaste: ((this: DocumentAndElementEventHandlers, ev: ClipboardEvent) => any) | null;
    readonly styleSheets: StyleSheetList;
    createElement(_tagName: string): HTMLElement;
    createDocumentFragment(): DocumentFragment;
    createTextNode(_data: string): Text;
    createComment(_data: string): Comment;
    createCDATASection(_data: string): CDATASection;
    createProcessingInstruction(_target: string, _data: string): ProcessingInstruction;
    createAttribute(_name: string): Attr;
    createEntityReference(_name: string): EntityReference;
    createElementNS(_namespaceURI: string, _qualifiedName: string): any;
    createAttributeNS(_namespaceURI: string, _qualifiedName: string): Attr;
    createExpression(_expression: string, _resolver?: XPathNSResolver | null | undefined): XPathExpression;
    createNSResolver(_nodeResolver: Node): XPathNSResolver;
    readonly URL: string;
    readonly activeElement: Element | null;
    readonly alinkColor: string;
    readonly all: HTMLAllCollection;
    readonly anchors: HTMLCollectionOf<HTMLAnchorElement>;
    readonly applets: HTMLCollectionOf<HTMLAppletElement>;
    readonly bgColor: string;
    readonly body: HTMLElement;
    readonly characterSet: string;
    readonly charset: string;
    readonly compatMode: string;
    readonly contentType: string;
    readonly cookie: string;
    readonly currentScript: HTMLScriptElement | SVGScriptElement | null;
    readonly defaultView: Window | null;
    readonly designMode: string;
    readonly dir: string;
    readonly domain: string;
    readonly embeds: HTMLCollectionOf<HTMLEmbedElement>;
    readonly fgColor: string;
    readonly forms: HTMLCollectionOf<HTMLFormElement>;
    readonly fullscreen: boolean;
    readonly fullscreenEnabled: boolean;
    readonly head: HTMLHeadElement;
    readonly hidden: boolean;
    readonly images: HTMLCollectionOf<HTMLImageElement>;
    readonly inputEncoding: string;
    readonly lastModified: string;
    readonly linkColor: string;
    readonly links: HTMLCollectionOf<HTMLAnchorElement | HTMLAreaElement>;
    readonly location: Location;
    readonly onfullscreenchange: ((this: Document, ev: Event) => any) | null;
    readonly onfullscreenerror: ((this: Document, ev: Event) => any) | null;
    readonly onpointerlockchange: ((this: Document, ev: Event) => any) | null;
    readonly onpointerlockerror: ((this: Document, ev: Event) => any) | null;
    readonly onreadystatechange: ((this: Document, ev: ProgressEvent) => any) | null;
    readonly onvisibilitychange: ((this: Document, ev: Event) => any) | null;
    readonly origin: string;
    readonly plugins: HTMLCollectionOf<HTMLEmbedElement>;
    readonly readyState: DocumentReadyState;
    readonly referrer: string;
    readonly scripts: HTMLCollectionOf<HTMLScriptElement>;
    readonly scrollingElement: Element | null;
    readonly timeline: DocumentTimeline;
    readonly title: string;
    readonly visibilityState: VisibilityState;
    readonly vlinkColor: string;
    adoptNode<T extends Node>(_source: T): T;
    captureEvents(): void;
    caretPositionFromPoint(_x: number, _y: number): CaretPosition | null;
    caretRangeFromPoint(_x: number, _y: number): Range;
    clear(): void;
    close(): void;
    createEvent(_eventInterface: any): any;
    createNodeIterator(_root: Node, _whatToShow?: number | undefined, _filter?: NodeFilter | null | undefined): NodeIterator;
    createRange(): Range;
    createTouch(_view: Window, _target: EventTarget, _identifier: number, _pageX: number, _pageY: number, _screenX: number, _screenY: number): Touch;
    createTouchList(..._touches: Touch[]): TouchList;
    createTreeWalker(_root: any, _whatToShow?: any, _filter?: any, _entityReferenceExpansion?: any): any;
    elementFromPoint(_x: number, _y: number): Element | null;
    elementsFromPoint(_x: number, _y: number): Element[];
    evaluate(_expression: string, _contextNode: Node, _resolver: XPathNSResolver | null, _type: number, _result: XPathResult | null): XPathResult;
    execCommand(_commandId: string, _showUI?: boolean | undefined, _value?: string | undefined): boolean;
    exitFullscreen(): Promise<void>;
    exitPointerLock(): void;
    getAnimations(): Animation[];
    getElementById(_elementId: string): HTMLElement | null;
    getElementsByClassName(_classNames: string): HTMLCollectionOf<Element>;
    getElementsByName(_elementName: string): NodeListOf<HTMLElement>;
    getElementsByTagName(_qualifiedName: any): any;
    getElementsByTagNameNS(_namespaceURI: any, _localName: any): any;
    getSelection(): Selection | null;
    hasFocus(): boolean;
    importNode<T extends Node>(_importedNode: T, _deep: boolean): T;
    open(_url?: string | undefined, _name?: string | undefined, _features?: string | undefined, _replace?: boolean | undefined): Document;
    queryCommandEnabled(_commandId: string): boolean;
    queryCommandIndeterm(_commandId: string): boolean;
    queryCommandState(_commandId: string): boolean;
    queryCommandSupported(_commandId: string): boolean;
    queryCommandValue(_commandId: string): string;
    releaseEvents(): void;
    write(..._text: string[]): void;
    writeln(..._text: string[]): void;
    readonly fullscreenElement: Element | null;
    readonly pointerLockElement: Element | null;
}
