import './types';
import { DocumentImpl } from './document';
import { DocumentTypeImpl } from './document-type';
import { DummyDOMIMplementation } from './dummy/dummy-dom-implementation';
/**
 * @see http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-102161490
 */
export declare class DOMImplementationImpl extends DummyDOMIMplementation {
    _features: Record<string, any>;
    constructor(features?: Record<string, any>);
    hasFeature(feature: string, version: string): true;
    createDocument(namespaceURI: string | null, qualifiedName: string | null, doctype: DocumentType | null): DocumentImpl;
    createDocumentType(qualifiedName: string, publicId: string, systemId: string): DocumentTypeImpl;
}
