"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("./types");
const named_node_map_1 = require("./named-node-map");
const node_list_of_1 = require("./node-list-of");
const utils_1 = require("./utils");
function cloneNode(doc, node, deep) {
    const node2 = new node.constructor();
    for (const n of Object.keys(node)) {
        const v = node[n];
        if (typeof v !== 'object') {
            if (v !== node2[n]) {
                node2[n] = v;
            }
        }
    }
    if (node.childNodes) {
        node2.childNodes = new node_list_of_1.NodeListOfImpl();
    }
    node2.ownerDocument = doc;
    if (utils_1.isElement(node) && utils_1.isElement(node2)) {
        const attrs = node.attributes;
        const attrs2 = (node2.attributes = new named_node_map_1.NamedNodeMapImpl());
        const len = attrs.length;
        attrs2._ownerElement = node2;
        for (let i = 0; i < len; i++) {
            node2.setAttributeNode(cloneNode(doc, attrs.item(i), true));
        }
    }
    else if (utils_1.isAttr(node2)) {
        deep = true;
    }
    if (deep) {
        let child = node.firstChild;
        while (child) {
            node2.appendChild(cloneNode(doc, child, deep));
            child = child.nextSibling;
        }
    }
    return node2;
}
exports.cloneNode = cloneNode;
function getTextContent(n) {
    let node = n;
    if (utils_1.isElement(node) || utils_1.isDocumentFragment(node)) {
        const buf = [];
        node = node.firstChild;
        while (node) {
            if (!utils_1.isProcessingInstruction(node) && !utils_1.isComment(node)) {
                const content = getTextContent(node);
                if (content != null) {
                    buf.push(content);
                }
            }
            node = node.nextSibling;
        }
        return buf.join('');
    }
    else {
        return node.nodeValue;
    }
}
exports.getTextContent = getTextContent;
//# sourceMappingURL=node-utils.js.map