"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("./types");
const serialize_1 = require("./serializer/serialize");
/**
 * @see http://www.w3.org/TR/2000/REC-DOM-Level-2-Core-20001113/core.html#ID-536297177
 * The NodeList interface provides the abstraction of an ordered collection of nodes,
 * without defining or constraining how this collection is implemented. NodeList objects in the DOM are live.
 * The items in the NodeList are accessible via an integral index, starting from 0.
 */
class NodeListImpl extends Array {
    /**
     * Returns the indexth item in the collection.
     * If index is greater than or equal to the number of nodes in the list, this returns null.
     *
     * @standard level1
     * @param index  unsigned long
     *   Index into the collection.
     * @return Node
     * 	The node at the indexth position in the NodeList, or null if that is not a valid index.
     */
    item(index) {
        return this[index] || null;
    }
    // added for compatiblity with current DOM spec
    namedItem(_name) {
        throw new Error('Method not implemented.');
    }
    forEach(callbackfn, thisArg) {
        super.forEach((value, key) => callbackfn(value, key, this), thisArg);
    }
    toString(isHTML, nodeFilter) {
        const buf = [];
        for (const item of this) {
            serialize_1.serializeToString(item, buf, isHTML, nodeFilter);
        }
        return buf.join('');
    }
}
exports.NodeListImpl = NodeListImpl;
//# sourceMappingURL=node-list.js.map