"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("./types");
const dom_exception_1 = require("./dom-exception");
const named_node_map_utils_1 = require("./named-node-map-utils");
/**
 *
 * Objects implementing the NamedNodeMap interface are used to represent collections of nodes
 * that can be accessed by name. Note that NamedNodeMap does not inherit from NodeList;
 * NamedNodeMaps are not maintained in any particular order. Objects contained in an object
 * implementing NamedNodeMap may also be accessed by an ordinal index, but this is simply to
 * allow convenient enumeration of the contents of a NamedNodeMap, and does not imply that
 * the DOM specifies an order to these Nodes.
 *
 * NamedNodeMap objects in the DOM are live.
 * used for attributes or DocumentType entities
 */
class NamedNodeMapImpl extends Array {
    item(index) {
        return this[index] || null;
    }
    getNamedItem(key) {
        // if(key.indexOf(':')>0 || key == 'xmlns'){
        //   return null;
        // }
        // console.log()
        let i = this.length;
        while (i--) {
            const attr = this[i];
            // console.log(attr.nodeName,key)
            if (attr.nodeName === key) {
                return attr;
            }
        }
        return null;
    }
    setNamedItem(attr) {
        const el = attr.ownerElement;
        if (el && el !== this._ownerElement) {
            throw new dom_exception_1.DOMExceptionImpl(dom_exception_1.DOMExceptionImpl.INUSE_ATTRIBUTE_ERR);
        }
        const oldAttr = this.getNamedItem(attr.nodeName);
        named_node_map_utils_1._addNamedNode(this._ownerElement, this, attr, oldAttr);
        return oldAttr;
    }
    /* returns Node */
    setNamedItemNS(attr) {
        // raises: WRONG_DOCUMENT_ERR,NO_MODIFICATION_ALLOWED_ERR,INUSE_ATTRIBUTE_ERR
        const el = attr.ownerElement;
        let oldAttr;
        if (el && el !== this._ownerElement) {
            throw new dom_exception_1.DOMExceptionImpl(dom_exception_1.DOMExceptionImpl.INUSE_ATTRIBUTE_ERR);
        }
        oldAttr = this.getNamedItemNS(attr.namespaceURI, attr.localName);
        named_node_map_utils_1._addNamedNode(this._ownerElement, this, attr, oldAttr);
        return oldAttr;
    }
    /* returns Node */
    removeNamedItem(key) {
        const attr = this.getNamedItem(key);
        if (attr === null) {
            throw new dom_exception_1.DOMExceptionImpl(dom_exception_1.DOMExceptionImpl.NOT_FOUND_ERR);
        }
        named_node_map_utils_1._removeNamedNode(this._ownerElement, this, attr);
        return attr;
    } // raises: NOT_FOUND_ERR,NO_MODIFICATION_ALLOWED_ERR
    // for level2
    removeNamedItemNS(namespaceURI, localName) {
        const attr = this.getNamedItemNS(namespaceURI, localName);
        if (attr === null) {
            throw new dom_exception_1.DOMExceptionImpl(dom_exception_1.DOMExceptionImpl.NOT_FOUND_ERR);
        }
        named_node_map_utils_1._removeNamedNode(this._ownerElement, this, attr);
        return attr;
    }
    getNamedItemNS(namespaceURI, localName) {
        let i = this.length;
        while (i--) {
            const node = this[i];
            if (node.localName === localName && node.namespaceURI === namespaceURI) {
                return node;
            }
        }
        return null;
    }
}
exports.NamedNodeMapImpl = NamedNodeMapImpl;
//# sourceMappingURL=named-node-map.js.map