"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("./types");
const document_utils_1 = require("./document-utils");
const dom_exception_1 = require("./dom-exception");
function _findNodeIndex(list, node) {
    let i = list.length;
    while (i--) {
        if (list[i] === node) {
            return i;
        }
    }
    // todo: I added this fix, needs to check if good
    return -1;
}
exports._findNodeIndex = _findNodeIndex;
function _addNamedNode(el, list, newAttr, oldAttr) {
    if (oldAttr) {
        list[_findNodeIndex(list, oldAttr)] = newAttr;
    }
    else {
        list[list.length++] = newAttr;
    }
    if (el) {
        newAttr.ownerElement = el;
        const doc = el.ownerDocument;
        if (doc) {
            if (oldAttr) {
                document_utils_1._onRemoveAttribute(doc, el, oldAttr);
            }
            document_utils_1._onAddAttribute(doc, el, newAttr);
        }
    }
}
exports._addNamedNode = _addNamedNode;
function _removeNamedNode(el, list, attr) {
    // console.log('remove attr:'+attr)
    let i = _findNodeIndex(list, attr);
    if (i >= 0) {
        const lastIndex = list.length - 1;
        while (i < lastIndex) {
            list[i] = list[++i];
        }
        list.length = lastIndex;
        if (el) {
            const doc = el.ownerDocument;
            if (doc) {
                document_utils_1._onRemoveAttribute(doc, el, attr);
                attr.ownerElement = null;
            }
        }
    }
    else {
        throw new dom_exception_1.DOMExceptionImpl(dom_exception_1.DOMExceptionImpl.NOT_FOUND_ERR, el.tagName + '@' + attr);
    }
}
exports._removeNamedNode = _removeNamedNode;
//# sourceMappingURL=named-node-map-utils.js.map