"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("./types");
const live_node_list_utils_1 = require("./live-node-list-utils");
class LiveNodeListImpl extends Array {
    constructor(node, refresh) {
        super();
        this._node = node;
        this._refresh = refresh;
        this._length = 0;
        live_node_list_utils_1._updateLiveList(this);
    }
    forEach(callbackfn, thisArg) {
        super.forEach((value, key) => callbackfn(value, key, this), thisArg);
    }
    item(i) {
        live_node_list_utils_1._updateLiveList(this);
        return this[i];
    }
    // added for compatiblity with current DOM spec
    namedItem(_name) {
        throw new Error('Method not implemented.');
    }
    get length() {
        live_node_list_utils_1._updateLiveList(this);
        return this._length;
    }
}
exports.LiveNodeListImpl = LiveNodeListImpl;
//# sourceMappingURL=live-node-list.js.map