"use strict";
const htmlns = 'http://www.w3.org/1999/xhtml';
function _xmlEncoder(c) {
    return ((c == '<' && '&lt;') ||
        (c == '>' && '&gt;') ||
        (c == '&' && '&amp;') ||
        (c == '"' && '&quot;') ||
        '&#' + c.charCodeAt() + ';');
}
// fixme
// Document.prototype.getElementsByTagName = Element.prototype.getElementsByTagName;
// Document.prototype.getElementsByTagNameNS = Element.prototype.getElementsByTagNameNS;
// class NotationImpl extends NodeImpl implements Notification {
//   constructor() {
//     super();
//     this.nodeType = NodeImpl.NOTATION_NODE;
//   }
// }
// class EntityImpl extends NodeImpl {
//   constructor() {
//     super();
//     this.nodeType = NodeImpl.ENTITY_NODE;
//   }
// }
function needNamespaceDefine(node, _isHTML, visibleNamespaces) {
    var prefix = node.prefix || '';
    var uri = node.namespaceURI;
    if (!prefix && !uri) {
        return false;
    }
    if ((prefix === 'xml' && uri === 'http://www.w3.org/XML/1998/namespace') || uri == 'http://www.w3.org/2000/xmlns/') {
        return false;
    }
    let i = visibleNamespaces.length;
    //console.log('@@@@',node.tagName,prefix,uri,visibleNamespaces)
    while (i--) {
        var ns = visibleNamespaces[i];
        // get namespace prefix
        //console.log(node.nodeType,node.tagName,ns.prefix,prefix)
        if (ns.prefix == prefix) {
            return ns.namespace != uri;
        }
    }
    //console.log(isHTML,uri,prefix=='')
    //if(isHTML && prefix ==null && uri == 'http://www.w3.org/1999/xhtml'){
    //	return false;
    //}
    //node.flag = '11111'
    //console.error(3,true,node.flag,node.prefix,node.namespaceURI)
    return true;
}
function importNode(doc, node, deep) {
    let node2;
    if (node instanceof ElementImpl) {
        node2 = node.cloneNode(false);
        node2.ownerDocument = doc;
        //var attrs = node2.attributes;
        //var len = attrs.length;
        //for(var i=0;i<len;i++){
        //node2.setAttributeNodeNS(importNode(doc,attrs.item(i),deep));
        //}
    }
    else if (node instanceof AttrImpl) {
        deep = true;
    }
    //case ENTITY_REFERENCE_NODE:
    //case PROCESSING_INSTRUCTION_NODE:
    ////case TEXT_NODE:
    //case CDATA_SECTION_NODE:
    //case COMMENT_NODE:
    //	deep = false;
    //	break;
    //case DOCUMENT_NODE:
    //case DOCUMENT_TYPE_NODE:
    //cannot be imported.
    //case ENTITY_NODE:
    //case NOTATION_NODE：
    //can not hit in level3
    //default:throw e;
    if (!node2) {
        node2 = node.cloneNode(false); //false
    }
    node2.ownerDocument = doc;
    node2.parentNode = null;
    if (deep) {
        var child = node.firstChild;
        while (child) {
            node2.appendChild(importNode(doc, child, deep));
            child = child.nextSibling;
        }
    }
    return node2;
}
//
//var _relationMap = {firstChild:1,lastChild:1,previousSibling:1,nextSibling:1,
//					attributes:1,childNodes:1,parentNode:1,documentElement:1,doctype,};
//# sourceMappingURL=dom.js.map