"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("./types");
const document_1 = require("./document");
const document_type_1 = require("./document-type");
const dummy_dom_implementation_1 = require("./dummy/dummy-dom-implementation");
const node_list_of_1 = require("./node-list-of");
/**
 * @see http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html#ID-102161490
 */
class DOMImplementationImpl extends dummy_dom_implementation_1.DummyDOMIMplementation {
    constructor(features) {
        super();
        this._features = {};
        if (features) {
            for (const feature of Object.keys(features)) {
                this._features = features[feature];
            }
        }
    }
    hasFeature(feature, version) {
        const versions = this._features[feature.toLowerCase()];
        if (versions && (!version || version in versions)) {
            return true;
        }
        else {
            return false; // because this call is really deprecated in modern DOM
        }
    }
    // Introduced in DOM Level 2:
    createDocument(namespaceURI, qualifiedName, doctype) {
        // raises:INVALID_CHARACTER_ERR,NAMESPACE_ERR,WRONG_DOCUMENT_ERR
        const doc = new document_1.DocumentImpl();
        doc.implementation = this;
        doc.childNodes = new node_list_of_1.NodeListOfImpl();
        doc.doctype = doctype;
        if (doctype) {
            doc.appendChild(doctype);
        }
        if (namespaceURI && qualifiedName) {
            const root = doc.createElementNS(namespaceURI, qualifiedName);
            doc.appendChild(root);
        }
        return doc;
    }
    createDocumentType(qualifiedName, publicId, systemId) {
        // raises:INVALID_CHARACTER_ERR,NAMESPACE_ERR
        const node = new document_type_1.DocumentTypeImpl();
        node.name = qualifiedName;
        node.nodeName = qualifiedName;
        node.publicId = publicId;
        node.systemId = systemId;
        // Introduced in DOM Level 2:
        // readonly attribute DOMString        internalSubset;
        // TODO:..
        //  readonly attribute NamedNodeMap     entities;
        //  readonly attribute NamedNodeMap     notations;
        return node;
    }
}
exports.DOMImplementationImpl = DOMImplementationImpl;
//# sourceMappingURL=dom-implementation.js.map