"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("./types");
const utils_1 = require("./utils");
/**
 * @param callback return true for continue,false for break
 * @return boolean true: break visit;
 */
function _visitNode(n, callback) {
    let node = n;
    if (callback(node)) {
        return true;
    }
    node = node.firstChild;
    while (node !== null) {
        if (_visitNode(node, callback)) {
            return true;
        }
        node = node.nextSibling;
    }
}
exports._visitNode = _visitNode;
function _onAddAttribute(doc, el, newAttr) {
    if (doc) {
        doc._inc++;
    }
    const ns = newAttr.namespaceURI;
    if (ns === 'http://www.w3.org/2000/xmlns/') {
        // update namespace
        el._nsMap[newAttr.prefix ? newAttr.localName : ''] = newAttr.value;
    }
}
exports._onAddAttribute = _onAddAttribute;
function _onRemoveAttribute(doc, el, newAttr, _remove) {
    if (doc) {
        doc._inc++;
    }
    const ns = newAttr.namespaceURI;
    if (ns === 'http://www.w3.org/2000/xmlns/') {
        // update namespace
        delete el._nsMap[newAttr.prefix ? newAttr.localName : ''];
    }
}
exports._onRemoveAttribute = _onRemoveAttribute;
function _onUpdateChild(doc, el, newChild) {
    if (doc && doc._inc) {
        doc._inc++;
        // update childNodes
        const cs = el.childNodes;
        if (newChild) {
            cs[cs.length++] = newChild;
        }
        else {
            // console.log(1)
            let child = el.firstChild;
            let i = 0;
            while (child) {
                cs[i++] = child;
                child = child.nextSibling;
            }
            cs.length = i;
        }
    }
}
exports._onUpdateChild = _onUpdateChild;
/**
 * attributes;
 * children;
 *
 * writeable properties:
 * nodeValue,Attr:value,CharacterData:data
 * prefix
 */
function _removeChild(parentNode, child) {
    const previous = child.previousSibling;
    const next = child.nextSibling;
    if (previous) {
        previous.nextSibling = next;
    }
    else {
        parentNode.firstChild = next;
    }
    if (next) {
        next.previousSibling = previous;
    }
    else {
        parentNode.lastChild = previous;
    }
    _onUpdateChild(parentNode.ownerDocument, parentNode);
    return child;
}
exports._removeChild = _removeChild;
/**
 * preformance key(refChild == null)
 */
function _insertBefore(parentNode, newChild, nextChild) {
    const cp = newChild.parentNode;
    if (cp) {
        cp.removeChild(newChild); // remove and update
    }
    let newFirst;
    let newLast;
    if (utils_1.isDocumentFragment(newChild)) {
        newFirst = newChild.firstChild;
        if (newFirst == null) {
            return newChild;
        }
        newLast = newChild.lastChild;
    }
    else {
        newFirst = newLast = newChild;
    }
    const pre = (nextChild ? nextChild.previousSibling : parentNode.lastChild);
    newFirst.previousSibling = pre;
    newLast.nextSibling = nextChild;
    if (pre) {
        pre.nextSibling = newFirst;
    }
    else {
        parentNode.firstChild = newFirst;
    }
    if (nextChild == null) {
        parentNode.lastChild = newLast;
    }
    else {
        nextChild.previousSibling = newLast;
    }
    do {
        newFirst.parentNode = parentNode;
        // tslint:disable-next-line:no-conditional-assignment
    } while (newFirst !== newLast && (newFirst = newFirst.nextSibling));
    _onUpdateChild(utils_1.isDocument(parentNode) ? parentNode : parentNode.ownerDocument, parentNode);
    if (utils_1.isDocumentFragment(newChild)) {
        newChild.firstChild = newChild.lastChild = null;
    }
    return newChild;
}
exports._insertBefore = _insertBefore;
function _appendSingleChild(parentNode, newChild) {
    const cp = newChild.parentNode;
    if (cp) {
        cp.removeChild(newChild); // remove and update
    }
    const pre = parentNode.lastChild;
    newChild.parentNode = parentNode;
    newChild.previousSibling = pre;
    newChild.nextSibling = null;
    if (pre) {
        pre.nextSibling = newChild;
    }
    else {
        parentNode.firstChild = newChild;
    }
    parentNode.lastChild = newChild;
    _onUpdateChild(parentNode.ownerDocument, parentNode, newChild);
    return newChild;
}
exports._appendSingleChild = _appendSingleChild;
function importNode(doc, node, deep) {
    let node2;
    if (utils_1.isElement(node)) {
        node2 = node.cloneNode(false);
        node2.ownerDocument = doc;
        // const attrs = node2.attributes;
        // const len = attrs.length;
        // for(let i=0;i<len;i++){
        //   node2.setAttributeNodeNS(importNode(doc,attrs.item(i),deep));
        // }
    }
    else if (utils_1.isAttr(node)) {
        deep = true;
    }
    // case ENTITY_REFERENCE_NODE:
    // case PROCESSING_INSTRUCTION_NODE:
    // case TEXT_NODE:
    // case CDATA_SECTION_NODE:
    // case COMMENT_NODE:
    // deep = false;
    // break;
    // case DOCUMENT_NODE:
    // case DOCUMENT_TYPE_NODE:
    // cannot be imported.
    // case ENTITY_NODE:
    // case NOTATION_NODE：
    // can not hit in level3
    // default:throw e;
    if (!node2) {
        node2 = node.cloneNode(false); // false
    }
    node2.ownerDocument = doc;
    node2.parentNode = null;
    if (deep) {
        let child = node.firstChild;
        while (child) {
            node2.appendChild(importNode(doc, child, deep));
            child = child.nextSibling;
        }
    }
    return node2;
}
exports.importNode = importNode;
//# sourceMappingURL=document-utils.js.map