"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SoapService = void 0;
const common_1 = require("@nestjs/common");
const soap_constants_1 = require("./soap-constants");
const soap_1 = require("soap");
let SoapService = class SoapService {
    constructor(soapModuleOptions) {
        this.soapModuleOptions = soapModuleOptions;
    }
    createAsyncClient() {
        return __awaiter(this, void 0, void 0, function* () {
            const options = this.soapModuleOptions;
            try {
                const client = yield (0, soap_1.createClientAsync)(options.uri, options.clientOptions);
                if (!options.auth)
                    return client;
                const { username, password } = options.auth;
                const authMethod = options.auth.type === soap_constants_1.WSSECURITY_AUTH
                    ? new soap_1.WSSecurity(username, password, options.auth.options)
                    : new soap_1.BasicAuthSecurity(username, password);
                client.setSecurity(authMethod);
                return client;
            }
            catch (err) {
                const logger = new common_1.Logger('SoapModule');
                logger.error(`${err.message} \n - An error occurred while creating the soap client. Check the SOAP service URL and status.`);
                return null;
            }
        });
    }
};
SoapService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, common_1.Inject)(soap_constants_1.SOAP_MODULE_OPTIONS)),
    __metadata("design:paramtypes", [Object])
], SoapService);
exports.SoapService = SoapService;
//# sourceMappingURL=soap.service.js.map