"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var SoapModule_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SoapModule = void 0;
const common_1 = require("@nestjs/common");
const soap_providers_1 = require("./soap-providers");
const soap_constants_1 = require("./soap-constants");
const soap_service_1 = require("./soap.service");
let SoapModule = SoapModule_1 = class SoapModule {
    static register(soapOptions) {
        return this.buildDynamicModule(soapOptions);
    }
    static forRoot(soapOptions) {
        return this.buildDynamicModule(soapOptions);
    }
    static registerAsync(soapOptions) {
        return this.buildAsyncDynamicModule(soapOptions);
    }
    static forRootAsync(soapOptions) {
        return this.buildAsyncDynamicModule(soapOptions);
    }
    static buildDynamicModule(soapOptions) {
        const clientProvider = (0, soap_providers_1.buildClientProvider)(soapOptions.clientName);
        const optionsProvider = {
            provide: soap_constants_1.SOAP_MODULE_OPTIONS,
            useValue: soapOptions,
        };
        return {
            module: SoapModule_1,
            providers: [
                optionsProvider,
                clientProvider,
                soap_service_1.SoapService,
            ],
            exports: [clientProvider, soap_service_1.SoapService],
        };
    }
    static buildAsyncDynamicModule(soapOptions) {
        const clientProvider = (0, soap_providers_1.buildClientProvider)(soapOptions.clientName);
        const asyncOptionsProviders = (0, soap_providers_1.buildAsyncProviders)(soapOptions);
        return {
            module: SoapModule_1,
            providers: [...asyncOptionsProviders, clientProvider, soap_service_1.SoapService],
            exports: [...asyncOptionsProviders, clientProvider, soap_service_1.SoapService],
            imports: soapOptions.imports || [],
        };
    }
};
SoapModule = SoapModule_1 = __decorate([
    (0, common_1.Module)({
        providers: [soap_service_1.SoapService],
        exports: [soap_service_1.SoapService],
    })
], SoapModule);
exports.SoapModule = SoapModule;
//# sourceMappingURL=soap.module.js.map