"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildAsyncProviders = exports.buildClientProvider = void 0;
const common_1 = require("@nestjs/common");
const soap_constants_1 = require("./soap-constants");
const soap_service_1 = require("./soap.service");
const buildClientProvider = (clientName) => ({
    provide: clientName,
    useFactory: (soapService) => __awaiter(void 0, void 0, void 0, function* () { return yield soapService.createAsyncClient(); }),
    inject: [soap_service_1.SoapService],
});
exports.buildClientProvider = buildClientProvider;
const buildAsyncProviders = (soapAsyncOptions) => {
    const { useClass, useExisting, useFactory } = soapAsyncOptions;
    if (useClass)
        return createUseClassProvider(soapAsyncOptions);
    if (useExisting)
        return createUseExistingProvider(soapAsyncOptions);
    if (useFactory)
        return createUseFactoryProvider(soapAsyncOptions);
    throw new Error('[SoapModule]: useClass, useExisting or useFactory must be filled when using async options.');
};
exports.buildAsyncProviders = buildAsyncProviders;
const createUseClassProvider = (option) => {
    const useClass = option.useClass;
    return [
        {
            provide: soap_constants_1.SOAP_MODULE_OPTIONS,
            useFactory: (optionsFactory) => __awaiter(void 0, void 0, void 0, function* () { return yield optionsFactory.createSoapModuleOptions(); }),
            inject: [useClass],
            scope: option.scope || common_1.Scope.DEFAULT,
        },
        {
            provide: useClass,
            useClass,
        },
    ];
};
const createUseExistingProvider = (option) => {
    return [
        {
            provide: soap_constants_1.SOAP_MODULE_OPTIONS,
            useFactory: (optionsFactory) => __awaiter(void 0, void 0, void 0, function* () { return yield optionsFactory.createSoapModuleOptions(); }),
            inject: [option.useExisting],
            scope: option.scope || common_1.Scope.DEFAULT,
        },
    ];
};
const createUseFactoryProvider = (option) => {
    return [
        {
            provide: soap_constants_1.SOAP_MODULE_OPTIONS,
            useFactory: option.useFactory,
            inject: option.inject || [],
            scope: option.scope || common_1.Scope.DEFAULT,
        },
    ];
};
//# sourceMappingURL=soap-providers.js.map