import { IPathStats } from '../interfaces';
/**
 * check director is symbolic link
 * @param {string} dir
 */
export declare function isSymbolicLink(dir: string): Promise<boolean>;
/**
 * check dir is directory
 * @param {string} dir
 */
export declare function isDir(dir: string): Promise<boolean>;
/**
 * check is file
 * @param file
 */
export declare function isFile(file: string): Promise<boolean>;
/**
 * check directory is readable
 *
 * @param {string} dir
 */
export declare function isReadable(dir: string): Promise<boolean>;
/**
 *
 * @param dir
 */
export declare function mkDir(dir: string, mode?: number | string): Promise<string[]>;
/**
 * read directory content
 * @param path
 */
export declare function getRecursiveDirectoryIterator(path: string): Promise<IPathStats[]>;
/**
 * read directory content
 * @param path
 */
export declare function getDirectoryIterator(path: string): Promise<IPathStats[]>;
/**
 * remove directory and files
 * @param dir
 */
export declare function rmDir(dir: string): Promise<boolean>;
