import { IVisibilityConverter } from '../../interfaces';
import { Visibility } from '../../enum';
export interface IPortableVisibilityConfig<T = number> {
    [Visibility.PUBLIC]?: T;
    [Visibility.PRIVATE]?: T;
}
export interface IPortableVisibilityObj<T = number> {
    file?: IPortableVisibilityConfig<T>;
    dir?: IPortableVisibilityConfig<T>;
}
export declare class PortableVisibilityConverter<T = number> implements IVisibilityConverter<T> {
    protected readonly filePublic: T;
    protected readonly filePrivate: T;
    protected readonly directoryPublic: T;
    protected readonly directoryPrivate: T;
    protected readonly _defaultForDirectories: Visibility;
    constructor(filePublic?: T, filePrivate?: T, directoryPublic?: T, directoryPrivate?: T, _defaultForDirectories?: Visibility);
    defaultForDirectories(): T;
    forDirectory(visibility: Visibility): T;
    /**
     * def
     * @param visibility
     */
    forFile(visibility: Visibility): T;
    inverseForDirectory(visibility: T): Visibility;
    inverseForFile(visibility: T): Visibility;
    static fromObject(permission: IPortableVisibilityObj, defaultForDirectories?: Visibility): PortableVisibilityConverter<number>;
}
