import { FilesystemOperationFailedException } from './filesystem-operation-failed.exception';
export declare class UnableToRetrieveMetadataException extends FilesystemOperationFailedException {
    /**
     * @var string
     */
    private _location;
    /**
     * @var string
     */
    private _metadataType;
    /**
     * @var string
     */
    private _reason;
    constructor(message: string);
    static lastModified(location: string, reason?: string, previous?: Error | null): UnableToRetrieveMetadataException;
    static visibility(location: string, reason?: string, previous?: Error | null): UnableToRetrieveMetadataException;
    static fileSize(location: string, reason?: string, previous?: Error | null): UnableToRetrieveMetadataException;
    static mimeType(location: string, reason?: string, previous?: Error | null): UnableToRetrieveMetadataException;
    static create(location: string, type: string, reason?: string, previous?: Error | null): UnableToRetrieveMetadataException;
    reason(): string;
    location(): string;
    metadataType(): string;
    operation(): string;
}
