import { Fecha } from '../class/Fecha';
export class MyString {
  dataByte: any = null;
  dataObject: any = null;

  value: any;

  constructor(valor: any) {
    this.updateValue(valor);
  }

  updateValue(valor: any) {
    this.dataObject = valor;
    if (
      valor != null &&
      valor != undefined &&
      typeof valor != 'string' &&
      typeof valor != 'object' &&
      typeof valor != 'number' &&
      typeof valor != 'boolean'
    ) {
      valor = `dataObject[${this.dataObject.name}]`;
    }
    valor = valor == null || valor == undefined ? '' : valor;
    this.value = valor;
  }

  setValue(valor: string) {
    this.value = valor;
  }

  getValue(): string {
    return this.value;
  }

  /**
   * retorna el objeto orignal recibido en caso de no haber recibido un tipo
   * de objeto byte[] ret
   *
   * @return Devuelve objeto original
   */
  getObject(): object {
    return this.dataObject;
  }

  /**
   * Retornara true o false segun el valor capturado
   *
   * @return true en caso que el texto sea "true", false en caso de ser
   * diferente
   */
  //     getBoolean(): boolean {
  //     return this.value == true;
  //   }

  /**
   * Obtener true si concide el dato enviado y el almacenado y false en caso
   * contrario
   *
   * @param valor_comparacion
   * @return true si el parametro es igual (respeta mayusculas y minusculas)
   * al dato almacenado
   */
  getBoolean(valor_comparacion?: boolean): boolean {
    if (valor_comparacion == undefined) {
      return this.value == true;
    } else if (valor_comparacion != undefined) {
      return this.value == valor_comparacion;
    }
    return this.value;
  }

  /**
   * Retornara el valor en entero
   *
   * @return el valor entero ingresado o en su defecto 0 de no haberse podido
   * hacer su conversion<br>
   * si se ingresa $20.55 devuelve 0 si se ingresa $20.00 devuelve 0 si se
   * ingresa 20 devuelve 20
   */
  getInt(): number {
    let cast: number = 0;
    cast = parseInt(this.setFormat());
    return cast;
  }

  /**
   * Devuelve el valor en double
   *
   * @return el valor entero ingresado o en su defecto 0 de no haberse podido
   * hacer su conversion<br>
   * si se ingresa $20.55 devuelve 20.55 si se ingresa $20.00 devuelve 20.0 si
   * se ingresa 20 devuelve 20
   */
  getDouble(): number {
    let cast: number = 0;
    cast = parseFloat(this.setFormat());
    return cast;
  }

  /**
   * incrementa el importe al valor original usando la funcion getDouble()+ el
   * valor del parametro
   *
   * @param importe importe que sumara al valor original
   */
  mas(importe: number) {
    this.updateValue(this.getDouble() + importe);
  }

  /**
   * decrementa el importe al valor original usando la funcion getDouble()+ el
   * valor del parametro
   *
   * @param importe importe que restara al valor original
   */
  menos(importe: number) {
    this.updateValue(this.getDouble() - importe);
  }

  /**
   * Convierte el Numero Recibido en un formato de moneda
   *
   * @return retornara el importe en formato moneda <br>
   * ej. si importe es 1000 retornara $ 1,000.00
   */
  getMoneda(): string {
    let valor: number = 0;
    valor = this.getDouble();
    return new Intl.NumberFormat('en-US', { style: 'currency', currency: 'MXN', minimumFractionDigits: 2 })
      .format(valor)
      .replace('MX', '');
  }

  /**
   * Convierte el Numero Recibido en un formato de porcentaje
   *
   * @return retornara el importe en formato porcentaje <br>
   * ej. si importe es 1000 retornara $ 1,000.00 ej. si importe es 3.14151618
   * retornara 3.14%
   *
   */
  getPorcentaje(): string {
    let valor: number = 0.0;
    valor = this.getDouble() / 100;
    // return String.format('%,.2f', valor) + ' %';
    return new Intl.NumberFormat('en-US', {
      style: 'percent',
      minimumFractionDigits: 2,
      maximumFractionDigits: 2,
    }).format(valor);
  }

  /**
   * Convierte la Cadena Recibida en double
   *
   * @return retornara el importe sin el formato de moneda o porcentaje<br>
   * ej. si importe es $ 1,000.00 retornara 1000.00 ej. si importe es 10.00%
   * retornara 10.00
   */
  setFormat(): string {
    let str: string = String(this.value).replace('%', '').replace('$', '').replace(',', '').trim();
    return str;
  }

  /**
   * Devuelve el valor en LocalDate
   *
   * @param defecto_permite_regresar_1900 true si el valor es 1900-01-01 regresara ese dato
   * @param defecto_obliga_regresar_1900 true si el valor es 1900-01-01 regresara ese dato
   * <br>ejemplo 1 getDate(true) permite regresar un valor 1900-01-01
   * <br>ejemplo 2 getDate(true,true) regresa un valor 1900-01-01 si el valor
   * no pudo ser casteable
   * @return el valor ingresado o en su defecto null de no haberse podido
   * hacer su conversion<br>
   * si se ingresa '1900-01-01' devuelve null si se ingresa '2000-01-01'
   * devuelve 2000-01-01
   */
  getDate(formato?: string, defecto_permite_regresar_1900?: boolean, defecto_obliga_regresar_1900?: boolean): string {
    let fecha: any = null;

    if (formato != undefined || formato != null) {
      if (this.value == null || String(this.value).trim() == '' || this.value.trim() == '1900-01-01') {
        fecha = '';
      } else {
        // fecha = LocalDate.parse(get().trim()).format(DateTimeFormatter.ofPattern(formato));
        fecha = Fecha.StoDate(this.value, formato);
      }
    } else if (defecto_permite_regresar_1900 != undefined && defecto_obliga_regresar_1900 != undefined) {
      let permite_regresar_1900: boolean = false;
      let obliga_regresar_1900: boolean = false;
      if (defecto_permite_regresar_1900 != undefined) {
        permite_regresar_1900 = defecto_permite_regresar_1900;
      }
      if (defecto_obliga_regresar_1900 != undefined) {
        obliga_regresar_1900 = defecto_obliga_regresar_1900;
      }
      let fecha_defecto: string = '1900-01-01';
      if (permite_regresar_1900) {
        fecha_defecto = '';
      }
      if (this.value != null && String(this.value).trim() != fecha_defecto) {
        try {
          // fecha = LocalDate.parse(get().trim());
          fecha = Fecha.StoDate(String(this.value).trim(), 'YYYY-MM-DD');
        } catch (error) {
          // fecha = LocalDate.parse(get().trim().substring(0, 10));
          fecha = Fecha.StoDate(String(this.value).trim().substring(0, 10), 'YYYY-MM-DD');
        }
      }
      if (obliga_regresar_1900 && fecha == null) {
        fecha = '1900-01-01';
      }
    }
    else if(formato == undefined && defecto_obliga_regresar_1900 == undefined && defecto_permite_regresar_1900 ==undefined) {
      fecha = Fecha.StoDate(String(this.value).trim().substring(0, 10), 'YYYY-MM-DD');
    }
    return fecha;
  }

  /**
   * Devuelve el valor en LocalDateTime
   * ^([0-2][0-9]|3[0-1])(\/|-)(0[1-9]|1[0-2])\2(\s)([0-1][0-9]|2[0-3])(:)([0-5][0-9])(:)([0-5][0-9])$
   *
   * @return el valor ingresado o en su defecto null de no haberse podido
   * hacer su conversion<br>
   * si se ingresa
   * <br> '1900-01-01' devuelve NULL
   * <br> '1900-01-01 00:00:00' devuelve NULL
   * <br> '2000-01-01' devuelve 2000-01-01 00:00:00
   * <br> '2000-01-01 14:15:12.555' devuelve 2000-01-01 14:15:12
   */
  getDateTime(): any {
    if (this.value == null || String(this.value).trim() == '' || String(this.value).trim().includes('1900-01-01')) {
      return null;
    } else {
      if (String(this.value).trim().toLowerCase().includes('-') && !String(this.value).trim().includes('GMT')) {
        return Fecha.StoDate(String(this.value).trim().replace(/ /g, 'T'), 'YYYY-MM-DD hh:mm:ss');
      } else {
        return Fecha.StoDate(this.value, 'YYYY-MM-DD hh:mm:ss');
      }
    }
  }

  size(): number {
    return this.value.length;
  }

  /**
   * convierte el contenido del MyString a una leyenda en formato porcentaje o
   * moneda
   * <br>ejemplo 1: UN PESO 00/100 M.N.
   * <br>ejemplo 2: UNO PUNTO CERO POR CIENTO
   *
   * @param es_moneda true para el caso que la leyenda sea en moneda, false
   * para el caso en que la leyenda sea en porcentaje
   * @param cero_default true devolvera el valor por default de CERO en caso
   * de que el valor de MyString no sea numerico
   * @return
   */
  getImporteLetra(cero_default?: boolean) {
    let valor: any = null;
    valor = this.getDouble();
    let default_cero: boolean = false;
    if (cero_default != undefined) {
      default_cero = cero_default;
    }
    let texto: string = '';
    if (valor == null) {
      if (default_cero) {
        // texto = N2T.setNumero(0).TMoneda(es_moneda).TPorcentaje(!es_moneda).build();
      }
    } else {
      // texto = N2T.setNumero(valor).TMoneda(es_moneda).TPorcentaje(!es_moneda).build();
    }
    return texto;
  }
}