function _regeneratorRuntime() {
  _regeneratorRuntime = function () {
    return exports;
  };
  var exports = {},
    Op = Object.prototype,
    hasOwn = Op.hasOwnProperty,
    defineProperty = Object.defineProperty || function (obj, key, desc) {
      obj[key] = desc.value;
    },
    $Symbol = "function" == typeof Symbol ? Symbol : {},
    iteratorSymbol = $Symbol.iterator || "@@iterator",
    asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator",
    toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag";
  function define(obj, key, value) {
    return Object.defineProperty(obj, key, {
      value: value,
      enumerable: !0,
      configurable: !0,
      writable: !0
    }), obj[key];
  }
  try {
    define({}, "");
  } catch (err) {
    define = function (obj, key, value) {
      return obj[key] = value;
    };
  }
  function wrap(innerFn, outerFn, self, tryLocsList) {
    var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator,
      generator = Object.create(protoGenerator.prototype),
      context = new Context(tryLocsList || []);
    return defineProperty(generator, "_invoke", {
      value: makeInvokeMethod(innerFn, self, context)
    }), generator;
  }
  function tryCatch(fn, obj, arg) {
    try {
      return {
        type: "normal",
        arg: fn.call(obj, arg)
      };
    } catch (err) {
      return {
        type: "throw",
        arg: err
      };
    }
  }
  exports.wrap = wrap;
  var ContinueSentinel = {};
  function Generator() {}
  function GeneratorFunction() {}
  function GeneratorFunctionPrototype() {}
  var IteratorPrototype = {};
  define(IteratorPrototype, iteratorSymbol, function () {
    return this;
  });
  var getProto = Object.getPrototypeOf,
    NativeIteratorPrototype = getProto && getProto(getProto(values([])));
  NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol) && (IteratorPrototype = NativeIteratorPrototype);
  var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype);
  function defineIteratorMethods(prototype) {
    ["next", "throw", "return"].forEach(function (method) {
      define(prototype, method, function (arg) {
        return this._invoke(method, arg);
      });
    });
  }
  function AsyncIterator(generator, PromiseImpl) {
    function invoke(method, arg, resolve, reject) {
      var record = tryCatch(generator[method], generator, arg);
      if ("throw" !== record.type) {
        var result = record.arg,
          value = result.value;
        return value && "object" == typeof value && hasOwn.call(value, "__await") ? PromiseImpl.resolve(value.__await).then(function (value) {
          invoke("next", value, resolve, reject);
        }, function (err) {
          invoke("throw", err, resolve, reject);
        }) : PromiseImpl.resolve(value).then(function (unwrapped) {
          result.value = unwrapped, resolve(result);
        }, function (error) {
          return invoke("throw", error, resolve, reject);
        });
      }
      reject(record.arg);
    }
    var previousPromise;
    defineProperty(this, "_invoke", {
      value: function (method, arg) {
        function callInvokeWithMethodAndArg() {
          return new PromiseImpl(function (resolve, reject) {
            invoke(method, arg, resolve, reject);
          });
        }
        return previousPromise = previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg();
      }
    });
  }
  function makeInvokeMethod(innerFn, self, context) {
    var state = "suspendedStart";
    return function (method, arg) {
      if ("executing" === state) throw new Error("Generator is already running");
      if ("completed" === state) {
        if ("throw" === method) throw arg;
        return doneResult();
      }
      for (context.method = method, context.arg = arg;;) {
        var delegate = context.delegate;
        if (delegate) {
          var delegateResult = maybeInvokeDelegate(delegate, context);
          if (delegateResult) {
            if (delegateResult === ContinueSentinel) continue;
            return delegateResult;
          }
        }
        if ("next" === context.method) context.sent = context._sent = context.arg;else if ("throw" === context.method) {
          if ("suspendedStart" === state) throw state = "completed", context.arg;
          context.dispatchException(context.arg);
        } else "return" === context.method && context.abrupt("return", context.arg);
        state = "executing";
        var record = tryCatch(innerFn, self, context);
        if ("normal" === record.type) {
          if (state = context.done ? "completed" : "suspendedYield", record.arg === ContinueSentinel) continue;
          return {
            value: record.arg,
            done: context.done
          };
        }
        "throw" === record.type && (state = "completed", context.method = "throw", context.arg = record.arg);
      }
    };
  }
  function maybeInvokeDelegate(delegate, context) {
    var methodName = context.method,
      method = delegate.iterator[methodName];
    if (undefined === method) return context.delegate = null, "throw" === methodName && delegate.iterator.return && (context.method = "return", context.arg = undefined, maybeInvokeDelegate(delegate, context), "throw" === context.method) || "return" !== methodName && (context.method = "throw", context.arg = new TypeError("The iterator does not provide a '" + methodName + "' method")), ContinueSentinel;
    var record = tryCatch(method, delegate.iterator, context.arg);
    if ("throw" === record.type) return context.method = "throw", context.arg = record.arg, context.delegate = null, ContinueSentinel;
    var info = record.arg;
    return info ? info.done ? (context[delegate.resultName] = info.value, context.next = delegate.nextLoc, "return" !== context.method && (context.method = "next", context.arg = undefined), context.delegate = null, ContinueSentinel) : info : (context.method = "throw", context.arg = new TypeError("iterator result is not an object"), context.delegate = null, ContinueSentinel);
  }
  function pushTryEntry(locs) {
    var entry = {
      tryLoc: locs[0]
    };
    1 in locs && (entry.catchLoc = locs[1]), 2 in locs && (entry.finallyLoc = locs[2], entry.afterLoc = locs[3]), this.tryEntries.push(entry);
  }
  function resetTryEntry(entry) {
    var record = entry.completion || {};
    record.type = "normal", delete record.arg, entry.completion = record;
  }
  function Context(tryLocsList) {
    this.tryEntries = [{
      tryLoc: "root"
    }], tryLocsList.forEach(pushTryEntry, this), this.reset(!0);
  }
  function values(iterable) {
    if (iterable) {
      var iteratorMethod = iterable[iteratorSymbol];
      if (iteratorMethod) return iteratorMethod.call(iterable);
      if ("function" == typeof iterable.next) return iterable;
      if (!isNaN(iterable.length)) {
        var i = -1,
          next = function next() {
            for (; ++i < iterable.length;) if (hasOwn.call(iterable, i)) return next.value = iterable[i], next.done = !1, next;
            return next.value = undefined, next.done = !0, next;
          };
        return next.next = next;
      }
    }
    return {
      next: doneResult
    };
  }
  function doneResult() {
    return {
      value: undefined,
      done: !0
    };
  }
  return GeneratorFunction.prototype = GeneratorFunctionPrototype, defineProperty(Gp, "constructor", {
    value: GeneratorFunctionPrototype,
    configurable: !0
  }), defineProperty(GeneratorFunctionPrototype, "constructor", {
    value: GeneratorFunction,
    configurable: !0
  }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, toStringTagSymbol, "GeneratorFunction"), exports.isGeneratorFunction = function (genFun) {
    var ctor = "function" == typeof genFun && genFun.constructor;
    return !!ctor && (ctor === GeneratorFunction || "GeneratorFunction" === (ctor.displayName || ctor.name));
  }, exports.mark = function (genFun) {
    return Object.setPrototypeOf ? Object.setPrototypeOf(genFun, GeneratorFunctionPrototype) : (genFun.__proto__ = GeneratorFunctionPrototype, define(genFun, toStringTagSymbol, "GeneratorFunction")), genFun.prototype = Object.create(Gp), genFun;
  }, exports.awrap = function (arg) {
    return {
      __await: arg
    };
  }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, asyncIteratorSymbol, function () {
    return this;
  }), exports.AsyncIterator = AsyncIterator, exports.async = function (innerFn, outerFn, self, tryLocsList, PromiseImpl) {
    void 0 === PromiseImpl && (PromiseImpl = Promise);
    var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl);
    return exports.isGeneratorFunction(outerFn) ? iter : iter.next().then(function (result) {
      return result.done ? result.value : iter.next();
    });
  }, defineIteratorMethods(Gp), define(Gp, toStringTagSymbol, "Generator"), define(Gp, iteratorSymbol, function () {
    return this;
  }), define(Gp, "toString", function () {
    return "[object Generator]";
  }), exports.keys = function (val) {
    var object = Object(val),
      keys = [];
    for (var key in object) keys.push(key);
    return keys.reverse(), function next() {
      for (; keys.length;) {
        var key = keys.pop();
        if (key in object) return next.value = key, next.done = !1, next;
      }
      return next.done = !0, next;
    };
  }, exports.values = values, Context.prototype = {
    constructor: Context,
    reset: function (skipTempReset) {
      if (this.prev = 0, this.next = 0, this.sent = this._sent = undefined, this.done = !1, this.delegate = null, this.method = "next", this.arg = undefined, this.tryEntries.forEach(resetTryEntry), !skipTempReset) for (var name in this) "t" === name.charAt(0) && hasOwn.call(this, name) && !isNaN(+name.slice(1)) && (this[name] = undefined);
    },
    stop: function () {
      this.done = !0;
      var rootRecord = this.tryEntries[0].completion;
      if ("throw" === rootRecord.type) throw rootRecord.arg;
      return this.rval;
    },
    dispatchException: function (exception) {
      if (this.done) throw exception;
      var context = this;
      function handle(loc, caught) {
        return record.type = "throw", record.arg = exception, context.next = loc, caught && (context.method = "next", context.arg = undefined), !!caught;
      }
      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
        var entry = this.tryEntries[i],
          record = entry.completion;
        if ("root" === entry.tryLoc) return handle("end");
        if (entry.tryLoc <= this.prev) {
          var hasCatch = hasOwn.call(entry, "catchLoc"),
            hasFinally = hasOwn.call(entry, "finallyLoc");
          if (hasCatch && hasFinally) {
            if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0);
            if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc);
          } else if (hasCatch) {
            if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0);
          } else {
            if (!hasFinally) throw new Error("try statement without catch or finally");
            if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc);
          }
        }
      }
    },
    abrupt: function (type, arg) {
      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
        var entry = this.tryEntries[i];
        if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) {
          var finallyEntry = entry;
          break;
        }
      }
      finallyEntry && ("break" === type || "continue" === type) && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc && (finallyEntry = null);
      var record = finallyEntry ? finallyEntry.completion : {};
      return record.type = type, record.arg = arg, finallyEntry ? (this.method = "next", this.next = finallyEntry.finallyLoc, ContinueSentinel) : this.complete(record);
    },
    complete: function (record, afterLoc) {
      if ("throw" === record.type) throw record.arg;
      return "break" === record.type || "continue" === record.type ? this.next = record.arg : "return" === record.type ? (this.rval = this.arg = record.arg, this.method = "return", this.next = "end") : "normal" === record.type && afterLoc && (this.next = afterLoc), ContinueSentinel;
    },
    finish: function (finallyLoc) {
      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
        var entry = this.tryEntries[i];
        if (entry.finallyLoc === finallyLoc) return this.complete(entry.completion, entry.afterLoc), resetTryEntry(entry), ContinueSentinel;
      }
    },
    catch: function (tryLoc) {
      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
        var entry = this.tryEntries[i];
        if (entry.tryLoc === tryLoc) {
          var record = entry.completion;
          if ("throw" === record.type) {
            var thrown = record.arg;
            resetTryEntry(entry);
          }
          return thrown;
        }
      }
      throw new Error("illegal catch attempt");
    },
    delegateYield: function (iterable, resultName, nextLoc) {
      return this.delegate = {
        iterator: values(iterable),
        resultName: resultName,
        nextLoc: nextLoc
      }, "next" === this.method && (this.arg = undefined), ContinueSentinel;
    }
  }, exports;
}
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
  try {
    var info = gen[key](arg);
    var value = info.value;
  } catch (error) {
    reject(error);
    return;
  }
  if (info.done) {
    resolve(value);
  } else {
    Promise.resolve(value).then(_next, _throw);
  }
}
function _asyncToGenerator(fn) {
  return function () {
    var self = this,
      args = arguments;
    return new Promise(function (resolve, reject) {
      var gen = fn.apply(self, args);
      function _next(value) {
        asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
      }
      function _throw(err) {
        asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
      }
      _next(undefined);
    });
  };
}

var Funciones = /*#__PURE__*/function () {
  function Funciones() {}
  /**
   * Rellena los espacios a la izquierda de la longitud deseada con la cadena
   * de rellono enviada
   *
   * @author Eder Ruíz
   * @fecha 09/09/2022
   *
   * @param cadenaOriginal string original
   * @param cadenaRelleno string de rellena
   * @param longitud numero de veces que se repetirá la cadena relleno
   * @returns cadena final
   */
  Funciones.LPAD =
  /*#__PURE__*/
  function () {
    var _LPAD = /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee(cadenaOriginal, cadenaRelleno, longitud) {
      return _regeneratorRuntime().wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            _context.t0 = cadenaOriginal.length;
            _context.next = _context.t0 === 1 ? 3 : _context.t0 === 2 ? 5 : _context.t0 === 3 ? 7 : _context.t0 === 4 ? 9 : 11;
            break;
          case 3:
            longitud = longitud;
            return _context.abrupt("break", 12);
          case 5:
            longitud -= 1;
            return _context.abrupt("break", 12);
          case 7:
            longitud -= 2;
            return _context.abrupt("break", 12);
          case 9:
            longitud -= 3;
            return _context.abrupt("break", 12);
          case 11:
            return _context.abrupt("break", 12);
          case 12:
            return _context.abrupt("return", "" + cadenaRelleno.repeat(longitud) + cadenaOriginal);
          case 13:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }));
    function LPAD(_x, _x2, _x3) {
      return _LPAD.apply(this, arguments);
    }
    return LPAD;
  }()
  /**
   * Función que redondea un calculo
   *
   * <b>Autor: </b> Aldair Cruz
   * <b>Fecha de Creación: </b> 12/03/2022
   *
   * @param {double} importe importe que será redondeado
   * @param {int} decimales Limite de Decimales a las cuales se redondeara
   * @returns regresa el impoorte redondeado
   */
  ;
  Funciones.round = function round(importe, decimales) {
    importe = Number(importe);
    return Number(importe.toFixed(decimales));
  };
  Funciones.totalCampo = function totalCampo(array, key, redondeo_decimales) {
    return Funciones.round(array.map(function (item) {
      return item[key];
    }).reduce(function (valor_anterior, valor_actual) {
      return valor_anterior + valor_actual;
    }, 0), redondeo_decimales);
  }
  /**
   * Convierte el Numero Recibido en un formato de moneda
   *
   * @param {double} importe
   */;
  Funciones.getMoneda = function getMoneda(importe) {
    return new Intl.NumberFormat('en-US', {
      style: 'currency',
      currency: 'MXN',
      minimumFractionDigits: 2
    }).format(importe).replace('MX', '');
  }
  /**
   * Convierte el Numero Recibido en un formato de porcentaje
   *
   * @param {double} importe
   * @return retornara el importe en formato porcentaje <br>
   * ej. si importe es 1000 retornara $ 1,000.00 ej. si importe es 3.14151618
   * retornara 3.14%
   */;
  Funciones.getPorcentaje = function getPorcentaje(importe) {
    return new Intl.NumberFormat('en-US', {
      style: 'percent',
      minimumFractionDigits: 2,
      maximumFractionDigits: 2
    }).format(importe);
  }
  /**
   * Devuelve una copia profunda de cualquier tipo de objeto o dato.
   * @param {any} objeto
   * @returns
   */;
  Funciones.copiaProfunda = function copiaProfunda(objeto) {
    var json_objeto = JSON.stringify(objeto);
    var copy = JSON.parse(json_objeto);
    return copy;
  };
  return Funciones;
}();

var moment = /*#__PURE__*/require('moment');
/**
 * Los método en la clase se van a referenciar a datos de tipo moment,
 * lo que nos refereimos a esto, es al paquete moment disponible en npm
 */
var Fecha = /*#__PURE__*/function () {
  function Fecha() {}
  /**
   *  Convierte una fecha de formato String a una fecha tipo moment
   *
   *  <b>Autor: </b> Aldair Cruz
   *  <b>Fecha de Creación: </b> 12/03/2022
   *
   * @param {string} fecha Se pasa la cadena de la fecha Ej: '2022-01-02'
   * @param {string} formato Se pasa el formato que se desea aplicar
   * @returns Regresa la fecha convertida a tipo moment con el formato deseado
   */
  Fecha.StoDate = function StoDate(fecha, formato) {
    return moment(fecha).format(formato);
  }
  /**
   * Obtiene la diferencia en dias entre 2 fechas especificas
   *
   * <b>Autor: </b> Aldair Cruz
   * <b>Fecha de Creación: </b> 12/03/2022
   *
   * @param {string} fecha_inicial Se pasa la fecha inicial
   * @param {string} fecha_final Se pasa la fecha final
   * @returns regresa la diferencia en dias entre la fecha inicial y la fecha final
   */;
  Fecha.diferenciaDias = function diferenciaDias(fecha_inicial, fecha_final) {
    return moment(fecha_final).diff(fecha_inicial, 'days');
  }
  /**
   * Obtiene la diferencia en meses entre 2 fechas especificas
   *
   * <b>Autor: </b> Aldair Cruz
   * <b>Fecha de Creación: </b> 12/03/2022
   *
   * @param {string} fecha_inicial Se pasa la fecha inicial
   * @param {string} fecha_final Se pasa la fecha final
   * @returns regresa la diferencia en meses entre la fecha inicial y la fecha final
   */;
  Fecha.diferenciaMes = function diferenciaMes(fecha_inicial, fecha_final) {
    return moment(fecha_final).diff(fecha_inicial, 'M');
  }
  /**
   * Obtiene la diferencia en años entre 2 fechas especificas
   *
   * <b>Autor: </b> Aldair Cruz
   * <b>Fecha de Creación: </b> 12/03/2022
   *
   * @param {string} fecha_inicial Se pasa la fecha inicial
   * @param {string} fecha_final Se pasa la fecha final
   * @returns regresa la diferencia en años entre la fecha inicial y la fecha final
   */;
  Fecha.diferenciaAnios = function diferenciaAnios(fecha_inicial, fecha_final) {
    return moment(fecha_final).diff(fecha_inicial, 'years');
  }
  /**
   * Obtiene el día de la fecha proporcionada
   *
   * @author Aldair Cruz
   *
   * @param {string} fecha
   * @returns
   */;
  Fecha.getDayOfMonth = function getDayOfMonth(fecha) {
    return Number(Fecha.StoDate(fecha, 'DD'));
  }
  /**
   * Obtiene el año de la fecha proporcionada
   *
   * @author Aldair Cruz
   *
   * @param {string} fecha
   * @returns
   */;
  Fecha.getYear = function getYear(fecha) {
    return Number(Fecha.StoDate(fecha, 'YYYY'));
  }
  /**
   * Obtiene el ultimo dia del mes que se le pase
   *
   * @author Aldair Cruz
   *
   * @param {string} fecha
   * @returns
   */;
  Fecha.getUltimoDiaMes = function getUltimoDiaMes(fecha) {
    return this.StoDate(moment(fecha).endOf('month'), 'YYYY-MM-DD');
  }
  /**
   * Obtiene el dia que se le pase del mes y año proporcionado
   *
   * @author Aldair Cruz
   *
   * @param {string} fecha
   * @param {int} dia
   * @returns
   */;
  Fecha.withDayOfMonth = function withDayOfMonth(fecha, dia) {
    var mes = this.StoDate(fecha, 'MM');
    var anio = this.StoDate(fecha, 'YYYY');
    var fecha_dia = anio + "-" + mes + "-" + dia;
    return this.StoDate(fecha_dia, 'YYYY-MM-DD');
  }
  /**
   * Se le suma a la fecha proporcionada el número de meses deseado
   *
   * @author Aldair Cruz
   *
   * @param {string} fecha
   * @param {int} numero_meses
   * @returns
   */;
  Fecha.plusMonths = function plusMonths(fecha, numero_meses) {
    return this.plusDate(fecha, numero_meses, 'M');
  };
  Fecha.minusMonths = function minusMonths(fecha, numero_meses) {
    return this.minusDate(fecha, numero_meses, 'M');
  }
  /**
   * Se le suma a la fecha proporcionada la cantidad de dias deseados
   *
   * @author Aldair Cruz
   *
   * @param {string} fecha
   * @param {int} numero_dias
   * @returns
   */;
  Fecha.plusDays = function plusDays(fecha, numero_dias) {
    return this.plusDate(fecha, numero_dias, 'days');
  };
  Fecha.minusDays = function minusDays(fecha, numero_dias) {
    return this.minusDate(fecha, numero_dias, 'days');
  };
  Fecha.plusYears = function plusYears(fecha, numero_anios) {
    return this.plusDate(fecha, numero_anios, 'years');
  };
  Fecha.minusYears = function minusYears(fecha, numero_anios) {
    return this.minusDate(fecha, numero_anios, 'years');
  };
  Fecha.lengthOfMonth = function lengthOfMonth(fecha) {
    return this.StoDate(moment(fecha).daysInMonth(), 'DD');
  }
  /**
   * Obtiene el Dia de la Semana
   *
   * @param {string} fecha
   * @returns
   */;
  Fecha.getDayOfWeek = function getDayOfWeek(fecha) {
    return moment(fecha).day() + 1;
  }
  /**
   * Método estandar por el cual se pasa para poder realizar la suma de dia, mes, etc
   * a la fecha deseada
   *
   * @author Aldair Cruz
   *
   * @param {string} fecha
   * @param {int} numero
   * @param {string} tipo
   * @returns
   */;
  Fecha.plusDate = function plusDate(fecha, numero, tipo) {
    return this.StoDate(moment(fecha).add(numero, tipo), 'YYYY-MM-DD');
  };
  Fecha.minusDate = function minusDate(fecha, numero, tipo) {
    return this.StoDate(moment(fecha).subtract(numero, tipo), 'YYYY-MM-DD');
  };
  return Fecha;
}();

var MyString = /*#__PURE__*/function () {
  function MyString(valor) {
    this.dataByte = null;
    this.dataObject = null;
    this.updateValue(valor);
  }
  var _proto = MyString.prototype;
  _proto.updateValue = function updateValue(valor) {
    this.dataObject = valor;
    if (valor != null && valor != undefined && typeof valor != 'string' && typeof valor != 'object' && typeof valor != 'number' && typeof valor != 'boolean') {
      valor = "dataObject[" + this.dataObject.name + "]";
    }
    valor = valor == null || valor == undefined ? '' : valor;
    this.value = valor;
  };
  _proto.setValue = function setValue(valor) {
    this.value = valor;
  };
  _proto.getValue = function getValue() {
    return this.value;
  }
  /**
   * retorna el objeto orignal recibido en caso de no haber recibido un tipo
   * de objeto byte[] ret
   *
   * @return Devuelve objeto original
   */;
  _proto.getObject = function getObject() {
    return this.dataObject;
  }
  /**
   * Retornara true o false segun el valor capturado
   *
   * @return true en caso que el texto sea "true", false en caso de ser
   * diferente
   */
  //     getBoolean(): boolean {
  //     return this.value == true;
  //   }
  /**
   * Obtener true si concide el dato enviado y el almacenado y false en caso
   * contrario
   *
   * @param valor_comparacion
   * @return true si el parametro es igual (respeta mayusculas y minusculas)
   * al dato almacenado
   */;
  _proto.getBoolean = function getBoolean(valor_comparacion) {
    if (valor_comparacion == undefined) {
      return this.value == true;
    } else if (valor_comparacion != undefined) {
      return this.value == valor_comparacion;
    }
    return this.value;
  }
  /**
   * Retornara el valor en entero
   *
   * @return el valor entero ingresado o en su defecto 0 de no haberse podido
   * hacer su conversion<br>
   * si se ingresa $20.55 devuelve 0 si se ingresa $20.00 devuelve 0 si se
   * ingresa 20 devuelve 20
   */;
  _proto.getInt = function getInt() {
    var cast = 0;
    cast = parseInt(this.setFormat());
    return cast;
  }
  /**
   * Devuelve el valor en double
   *
   * @return el valor entero ingresado o en su defecto 0 de no haberse podido
   * hacer su conversion<br>
   * si se ingresa $20.55 devuelve 20.55 si se ingresa $20.00 devuelve 20.0 si
   * se ingresa 20 devuelve 20
   */;
  _proto.getDouble = function getDouble() {
    var cast = 0;
    cast = parseFloat(this.setFormat());
    return cast;
  }
  /**
   * incrementa el importe al valor original usando la funcion getDouble()+ el
   * valor del parametro
   *
   * @param importe importe que sumara al valor original
   */;
  _proto.mas = function mas(importe) {
    this.updateValue(this.getDouble() + importe);
  }
  /**
   * decrementa el importe al valor original usando la funcion getDouble()+ el
   * valor del parametro
   *
   * @param importe importe que restara al valor original
   */;
  _proto.menos = function menos(importe) {
    this.updateValue(this.getDouble() - importe);
  }
  /**
   * Convierte el Numero Recibido en un formato de moneda
   *
   * @return retornara el importe en formato moneda <br>
   * ej. si importe es 1000 retornara $ 1,000.00
   */;
  _proto.getMoneda = function getMoneda() {
    var valor = 0;
    valor = this.getDouble();
    return new Intl.NumberFormat('en-US', {
      style: 'currency',
      currency: 'MXN',
      minimumFractionDigits: 2
    }).format(valor).replace('MX', '');
  }
  /**
   * Convierte el Numero Recibido en un formato de porcentaje
   *
   * @return retornara el importe en formato porcentaje <br>
   * ej. si importe es 1000 retornara $ 1,000.00 ej. si importe es 3.14151618
   * retornara 3.14%
   *
   */;
  _proto.getPorcentaje = function getPorcentaje() {
    var valor = 0.0;
    valor = this.getDouble() / 100;
    // return String.format('%,.2f', valor) + ' %';
    return new Intl.NumberFormat('en-US', {
      style: 'percent',
      minimumFractionDigits: 2,
      maximumFractionDigits: 2
    }).format(valor);
  }
  /**
   * Convierte la Cadena Recibida en double
   *
   * @return retornara el importe sin el formato de moneda o porcentaje<br>
   * ej. si importe es $ 1,000.00 retornara 1000.00 ej. si importe es 10.00%
   * retornara 10.00
   */;
  _proto.setFormat = function setFormat() {
    var str = String(this.value).replace('%', '').replace('$', '').replace(',', '').trim();
    return str;
  }
  /**
   * Devuelve el valor en LocalDate
   *
   * @param defecto_permite_regresar_1900 true si el valor es 1900-01-01 regresara ese dato
   * @param defecto_obliga_regresar_1900 true si el valor es 1900-01-01 regresara ese dato
   * <br>ejemplo 1 getDate(true) permite regresar un valor 1900-01-01
   * <br>ejemplo 2 getDate(true,true) regresa un valor 1900-01-01 si el valor
   * no pudo ser casteable
   * @return el valor ingresado o en su defecto null de no haberse podido
   * hacer su conversion<br>
   * si se ingresa '1900-01-01' devuelve null si se ingresa '2000-01-01'
   * devuelve 2000-01-01
   */;
  _proto.getDate = function getDate(formato, defecto_permite_regresar_1900, defecto_obliga_regresar_1900) {
    var fecha = null;
    if (formato != undefined || formato != null) {
      if (this.value == null || String(this.value).trim() == '' || this.value.trim() == '1900-01-01') {
        fecha = '';
      } else {
        // fecha = LocalDate.parse(get().trim()).format(DateTimeFormatter.ofPattern(formato));
        fecha = Fecha.StoDate(this.value, formato);
      }
    } else if (defecto_permite_regresar_1900 != undefined && defecto_obliga_regresar_1900 != undefined) {
      var permite_regresar_1900 = false;
      var obliga_regresar_1900 = false;
      if (defecto_permite_regresar_1900 != undefined) {
        permite_regresar_1900 = defecto_permite_regresar_1900;
      }
      if (defecto_obliga_regresar_1900 != undefined) {
        obliga_regresar_1900 = defecto_obliga_regresar_1900;
      }
      var fecha_defecto = '1900-01-01';
      if (permite_regresar_1900) {
        fecha_defecto = '';
      }
      if (this.value != null && String(this.value).trim() != fecha_defecto) {
        try {
          // fecha = LocalDate.parse(get().trim());
          fecha = Fecha.StoDate(String(this.value).trim(), 'YYYY-MM-DD');
        } catch (error) {
          // fecha = LocalDate.parse(get().trim().substring(0, 10));
          fecha = Fecha.StoDate(String(this.value).trim().substring(0, 10), 'YYYY-MM-DD');
        }
      }
      if (obliga_regresar_1900 && fecha == null) {
        fecha = '1900-01-01';
      }
    } else if (formato == undefined && defecto_obliga_regresar_1900 == undefined && defecto_permite_regresar_1900 == undefined) {
      fecha = Fecha.StoDate(String(this.value).trim().substring(0, 10), 'YYYY-MM-DD');
    }
    return fecha;
  }
  /**
   * Devuelve el valor en LocalDateTime
   * ^([0-2][0-9]|3[0-1])(\/|-)(0[1-9]|1[0-2])\2(\s)([0-1][0-9]|2[0-3])(:)([0-5][0-9])(:)([0-5][0-9])$
   *
   * @return el valor ingresado o en su defecto null de no haberse podido
   * hacer su conversion<br>
   * si se ingresa
   * <br> '1900-01-01' devuelve NULL
   * <br> '1900-01-01 00:00:00' devuelve NULL
   * <br> '2000-01-01' devuelve 2000-01-01 00:00:00
   * <br> '2000-01-01 14:15:12.555' devuelve 2000-01-01 14:15:12
   */;
  _proto.getDateTime = function getDateTime() {
    if (this.value == null || String(this.value).trim() == '' || String(this.value).trim().includes('1900-01-01')) {
      return null;
    } else {
      if (String(this.value).trim().toLowerCase().includes('-') && !String(this.value).trim().includes('GMT')) {
        return Fecha.StoDate(String(this.value).trim().replace(/ /g, 'T'), 'YYYY-MM-DD hh:mm:ss');
      } else {
        return Fecha.StoDate(this.value, 'YYYY-MM-DD hh:mm:ss');
      }
    }
  };
  _proto.size = function size() {
    return this.value.length;
  }
  /**
   * convierte el contenido del MyString a una leyenda en formato porcentaje o
   * moneda
   * <br>ejemplo 1: UN PESO 00/100 M.N.
   * <br>ejemplo 2: UNO PUNTO CERO POR CIENTO
   *
   * @param es_moneda true para el caso que la leyenda sea en moneda, false
   * para el caso en que la leyenda sea en porcentaje
   * @param cero_default true devolvera el valor por default de CERO en caso
   * de que el valor de MyString no sea numerico
   * @return
   */;
  _proto.getImporteLetra = function getImporteLetra(cero_default) {
    var valor = null;
    valor = this.getDouble();
    var texto = '';
    return texto;
  };
  return MyString;
}();

export { Fecha, Funciones, MyString };
//# sourceMappingURL=utilerias-ts.esm.js.map
