export declare class MyString {
    dataByte: any;
    dataObject: any;
    value: any;
    constructor(valor: any);
    updateValue(valor: any): void;
    setValue(valor: string): void;
    getValue(): string;
    /**
     * retorna el objeto orignal recibido en caso de no haber recibido un tipo
     * de objeto byte[] ret
     *
     * @return Devuelve objeto original
     */
    getObject(): object;
    /**
     * Retornara true o false segun el valor capturado
     *
     * @return true en caso que el texto sea "true", false en caso de ser
     * diferente
     */
    /**
     * Obtener true si concide el dato enviado y el almacenado y false en caso
     * contrario
     *
     * @param valor_comparacion
     * @return true si el parametro es igual (respeta mayusculas y minusculas)
     * al dato almacenado
     */
    getBoolean(valor_comparacion?: boolean): boolean;
    /**
     * Retornara el valor en entero
     *
     * @return el valor entero ingresado o en su defecto 0 de no haberse podido
     * hacer su conversion<br>
     * si se ingresa $20.55 devuelve 0 si se ingresa $20.00 devuelve 0 si se
     * ingresa 20 devuelve 20
     */
    getInt(): number;
    /**
     * Devuelve el valor en double
     *
     * @return el valor entero ingresado o en su defecto 0 de no haberse podido
     * hacer su conversion<br>
     * si se ingresa $20.55 devuelve 20.55 si se ingresa $20.00 devuelve 20.0 si
     * se ingresa 20 devuelve 20
     */
    getDouble(): number;
    /**
     * incrementa el importe al valor original usando la funcion getDouble()+ el
     * valor del parametro
     *
     * @param importe importe que sumara al valor original
     */
    mas(importe: number): void;
    /**
     * decrementa el importe al valor original usando la funcion getDouble()+ el
     * valor del parametro
     *
     * @param importe importe que restara al valor original
     */
    menos(importe: number): void;
    /**
     * Convierte el Numero Recibido en un formato de moneda
     *
     * @return retornara el importe en formato moneda <br>
     * ej. si importe es 1000 retornara $ 1,000.00
     */
    getMoneda(): string;
    /**
     * Convierte el Numero Recibido en un formato de porcentaje
     *
     * @return retornara el importe en formato porcentaje <br>
     * ej. si importe es 1000 retornara $ 1,000.00 ej. si importe es 3.14151618
     * retornara 3.14%
     *
     */
    getPorcentaje(): string;
    /**
     * Convierte la Cadena Recibida en double
     *
     * @return retornara el importe sin el formato de moneda o porcentaje<br>
     * ej. si importe es $ 1,000.00 retornara 1000.00 ej. si importe es 10.00%
     * retornara 10.00
     */
    setFormat(): string;
    /**
     * Devuelve el valor en LocalDate
     *
     * @param defecto_permite_regresar_1900 true si el valor es 1900-01-01 regresara ese dato
     * @param defecto_obliga_regresar_1900 true si el valor es 1900-01-01 regresara ese dato
     * <br>ejemplo 1 getDate(true) permite regresar un valor 1900-01-01
     * <br>ejemplo 2 getDate(true,true) regresa un valor 1900-01-01 si el valor
     * no pudo ser casteable
     * @return el valor ingresado o en su defecto null de no haberse podido
     * hacer su conversion<br>
     * si se ingresa '1900-01-01' devuelve null si se ingresa '2000-01-01'
     * devuelve 2000-01-01
     */
    getDate(formato?: string, defecto_permite_regresar_1900?: boolean, defecto_obliga_regresar_1900?: boolean): string;
    /**
     * Devuelve el valor en LocalDateTime
     * ^([0-2][0-9]|3[0-1])(\/|-)(0[1-9]|1[0-2])\2(\s)([0-1][0-9]|2[0-3])(:)([0-5][0-9])(:)([0-5][0-9])$
     *
     * @return el valor ingresado o en su defecto null de no haberse podido
     * hacer su conversion<br>
     * si se ingresa
     * <br> '1900-01-01' devuelve NULL
     * <br> '1900-01-01 00:00:00' devuelve NULL
     * <br> '2000-01-01' devuelve 2000-01-01 00:00:00
     * <br> '2000-01-01 14:15:12.555' devuelve 2000-01-01 14:15:12
     */
    getDateTime(): any;
    size(): number;
    /**
     * convierte el contenido del MyString a una leyenda en formato porcentaje o
     * moneda
     * <br>ejemplo 1: UN PESO 00/100 M.N.
     * <br>ejemplo 2: UNO PUNTO CERO POR CIENTO
     *
     * @param es_moneda true para el caso que la leyenda sea en moneda, false
     * para el caso en que la leyenda sea en porcentaje
     * @param cero_default true devolvera el valor por default de CERO en caso
     * de que el valor de MyString no sea numerico
     * @return
     */
    getImporteLetra(cero_default?: boolean): string;
}
